package com.ella.resource.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

@ApiModel("IRA阅读报告需要用到的阅读时长和阅读次数记录表")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class IraReadRecordDto implements Serializable {

    private static final long serialVersionUID = -4816089702412952285L;
    @ApiModelProperty("主键")
    private Integer id;
    @ApiModelProperty("孩子uid")
    private String uid;
    @ApiModelProperty("地图code")
    private String mapCode;
    @ApiModelProperty("关卡code")
    private String missionCode;
    @ApiModelProperty("阅读时长")
    private Integer readTime;
    @ApiModelProperty("阅读记录提交时间")
    private Date commitTime;
    @ApiModelProperty("单次阅读起止时间碎片")
    private String readStartEnds;
}
