package com.ella.resource.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author liyuanyuan
 * @dscription 描述
 * @date 2019/11/15 16:53
 */
@Data
@ApiModel("Ira一级指标")
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class IraFirstAbilityReportDto implements Serializable {

    private static final long serialVersionUID = -4494546896105595673L;

    @ApiModelProperty(notes = "主键ID")
    private Integer id;

    @ApiModelProperty(notes = "一级指标code")
    private String firstCode;

    @ApiModelProperty(notes = "报表code")
    private String reportCode;

    /**
     * 得分/满分
     */
    @ApiModelProperty(notes = "ira值")
    private Integer iraNum;

    /**
     * 本次-上次
     */
    @ApiModelProperty(notes = "ira值变化量")
    private Integer iraNumChange;

    /**
     * 该一级指标对应的已答题目数/该一级指标对应的所有题目总数
     */

    @ApiModelProperty(notes = "互动次数-总题目数")
    private Integer interactTotal;

    @ApiModelProperty(notes = "互动次数-已答题目数")
    private Integer interactFinished;

    /**
     * 该一级指标对应的已答题目实际得分/该一级指标对应的已答题目理论总分
     */
    @ApiModelProperty(notes = "互动质量")
    private Float interactQuality;

    @ApiModelProperty(notes = "一级能力指标类型")
    private Integer firstType;

    @ApiModelProperty(notes = "排序")
    private Integer idx;

    @ApiModelProperty(notes = "报告最近一次生成时的时间")
    private Date reportTime;

    /**
     * 是否可用:NOMAL-正常  EXCEPTION-异常
     */
    @ApiModelProperty(notes = "是否可用状态")
    private String status;

    /**
     * 0：修改、1：新增、-1：删除
     */
    @ApiModelProperty(notes = "保存状态")
    private int saveStatus;

    private List<IraSecondAbilityReportDto> secondAbilitys;

}
