package com.ella.resource.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @author ZLN
 * @create 2018-08-06 19:07
 **/
@Data
@ApiModel("绘本详情返回值")
public class GetPicBookInfoDto implements Serializable {

    private static final long serialVersionUID = -3442394506338878257L;

    @ApiModelProperty("介绍")
    private String bookIntroduction;

    @ApiModelProperty("系列名")
    private String seriesName;

    @ApiModelProperty("封面")
    private String coverUrl;

    @ApiModelProperty("名称")
    private String bookName;

    @ApiModelProperty("图书Code")
    private String bookCode;
    @ApiModelProperty("绘本Code")
    private String picBookCode;

    @ApiModelProperty("绘本资源url")
    private String resourceUrl;
    @ApiModelProperty("多少人读过")
    private Integer readeCount;
    //

    @ApiModelProperty("适用年龄")
    private String forAge;

    @ApiModelProperty("蓝思值")
    private String lexileLevel;

    @ApiModelProperty("蓝思级别")
    private String levelCode;

    @ApiModelProperty("标签")
    private String tags;

    @ApiModelProperty("预览视频url")
    private String videoUrl;

    @ApiModelProperty("预览图片url")
    private List<String> preImage;

    @ApiModelProperty("介绍")
    private String description;

    @ApiModelProperty("商品类型")
    private String goodsType;

    @ApiModelProperty("商品价格")
    private BigDecimal goodsPrice;

    @ApiModelProperty("支付类型")
    private String supportPayType;

    @ApiModelProperty("是否购买：ture false")
    private Boolean isBuy;

    @ApiModelProperty("校审")
    private String reviewerMan;
    @ApiModelProperty("音频")
    private String radioMan;
    @ApiModelProperty("动画设计")
    private String interactionEffect;
    @ApiModelProperty("美术")
    private String picHandle;
    @ApiModelProperty("作者")
    private String authorText;
    @ApiModelProperty("绘者")
    private String painting;
    @ApiModelProperty("版权所有")
    private String bookPressName;

    @ApiModelProperty("同级别推荐")
    private List<PicBookStoreDto> levelRecommend;

    @ApiModelProperty("ture 已经读完  false 未读完  注:用于APP发表评论")
    private Boolean isReadFinish;

    @ApiModelProperty("纸质书价格")
    private String paperBookPrice;

    @ApiModelProperty("出版社名称")
    private String publishName;

    @ApiModelProperty("图书评分")
    private Float bookScore;

    @ApiModelProperty("蓝思指数类别code")
    private String lexileLevelCode;

    @ApiModelProperty("书籍是否下架")
    private Boolean available = true;

    @ApiModelProperty(notes = "图书资源版本号")
    private String version;

    private Integer trialReadPage = 4;
}
