package com.ella.resource.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author ZLN
 * @create 2018-07-28 15:01
 **/

@ApiModel("课程列表返回")
@Data
public class CourseListDto implements Serializable {
    private static final long serialVersionUID = -1175147048630615099L;
    @ApiModelProperty("主键id")
    private Integer id;
    @ApiModelProperty("课程名称")
    private String courseName;
    @ApiModelProperty("课程code")
    private String courseCode;
    @ApiModelProperty("关联动画书code")
    private String bookCode;
    @ApiModelProperty("系列名")
    private String seriesName;

    private String bookName;

    @ApiModelProperty("蓝思评级")
    private String lexileLevel;
    @ApiModelProperty("词汇个数")
    private Integer vocabularyNum;
    @ApiModelProperty("词汇具体介绍")
    private String vocabularyDesc;

    @ApiModelProperty("语法个数")
    private Integer grammarNum;
    @ApiModelProperty("语法具体介绍")
    private String grammarDesc;
    @ApiModelProperty("拼读个数")
    private Integer phonicNum;
    @ApiModelProperty("拼读具体介绍")
    private String phonicDesc;
    @ApiModelProperty("过关提示语")
    private String winTips;

    private String failTips;

    private String videoUrl;

    private String testUrl;
    @ApiModelProperty("测试题数量")
    private Integer testNum;
    @ApiModelProperty("使用状态 (N-未使用，Y-已使用)")
    private String useStatus;

    private Date createTime;
    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("删除课程使用--值:EXCEPTION")
    private String status;
    @ApiModelProperty("蓝思指数类型")
    private String lexileResTypeCode;
}
