package com.ella.resource.constants;

/**
 * @author Libin
 */
public enum RetCodeEnum {
    /**
     * 业务异常代码
     */
    LEVEL_NOT_EXISTS("404001", "等级不存在"),
    MAP_NOT_EXISTS("404002", "地图不存在"),
    MAP_ORDER_ALREADY_EXISTS("404003", "该等级的地图序号已经存在"),
    UNABLE_OPERATE_FOR_SURE("404004", "已确认,无法操作"),
    MISSION_NOT_EXISTS("404005", "啊哦，这个关卡正在维护中...去玩其他关卡吧"),
    CONTAIN_MISSION_NOT_IN_GOODS("404006", "包含非商品的关卡"),
    MISSION_INDEX_NOT_EXISTS("404007", "隐藏关卡所关联的父关卡序号不存在"),
    UPDATE_FILL("404008", "修改失败,影响行数0"),
    DELETE_FILL("404009", "不能删除,资源正在使用"),
    INSERT_FILL("404010", "插入失败"),
    USER_NOT_EXISTS("404011", "用户不存在"),
    COURSE_NOT_EXISTS("404012", "课程不存在"),
    COURSE_TEST_ORDER_ERROR("404013", "过关测验需按顺序完成"),
    USER_COURSE_DATA_ERROR("404014", "用户课程数据异常"),
    BOOK_LEVEL_ALREADY_EXISTS("404015", "该绘本等级已存在"),
    READ_INSERT_ERROR("404016", "阅读记录插入失败"),
    MISSION_RESOURCE_IS_NULL("404017", "关卡资源未配置"),
    EXISTS_IN_PICTURE_BOOK("404018", "该动画书已被使用为绘本"),
    EXISTS_IN_COURSE_BOOK("404019", "该动画书已被课程使用"),
    COURSE_REPORT_NOT_EXISTS("404020", "课程学习报告不存在"),
    REF_MAP_RESOURCE_SURE("404021", "该关卡所属地图已发布，不能移动"),
    MAP_INDEX_ERROR("404022", "地图序号应为连续整数"),
    MISSION_INDEX_ERROR("404023", "关卡序号应为连续整数"),
    IOS_PRICE_CODE_NON_ERROR("404024", "ios价格认证编码不存在"),
    INCOMPLETE_PARAMETERS_ERROR("404025", "请求参数不完整"),
    MAP_RESOURCE_EXISTS("404025", "地图资源已占用");
    private final String code;

    private final String msg;

    RetCodeEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String msg() {
        return this.msg;
    }

    public static RetCodeEnum getEnumByCode(String code) {
        for (RetCodeEnum codeEnum : RetCodeEnum.values()) {
            if (codeEnum.code.equals(code)) {
                return codeEnum;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getMsg() {
        return msg;
    }
}
