package com.ella.resource.constants;

/**
 * 蓝思评测进行状态枚举
 *
 * @author maofengHan
 */
public enum LexileEvaluationStatusEnum {
    /**
     * 进行中
     */
    UNDERWAY("UNDERWAY"),
    /**
     * 未完成
     */
    UNCOMPLETED("UNCOMPLETED"),
    /**
     * 已完成
     */
    COMPLETED("COMPLETED");

    private LexileEvaluationStatusEnum(String code) {
        this.code = code;
    }

    private String code;

    public String getCode() {
        return code;
    }

    /**
     * 根据状态字符串(code)获取Enum
     *
     * @param code
     * @return
     */
    public static LexileEvaluationStatusEnum forCode(String code) {
        for (LexileEvaluationStatusEnum e : LexileEvaluationStatusEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }

    /**
     * 是否包含指定状态
     *
     * @param code
     * @return
     */
    public static boolean contains(String code) {
        return forCode(code) != null;
    }

    public boolean equalTo(String code) {
        return this.getCode().equals(code);
    }
}
