package com.ella.resource.constants;

public enum LevelEnum {
    /**
     * 蓝思级别
     */
    LV0(DataConstants.CONSTANT_ZERO, "0",""),
    LV1(DataConstants.CONSTANT_ONE, "1","适合国内幼儿园至小学1年级孩子英语阅读启蒙"),
    LV2(DataConstants.CONSTANT_TWO, "2","适合提升国内小学2-3年级孩子的英语阅读能力"),
    LV3(DataConstants.CONSTANT_THREE, "3","适合提升国内小学3-4年级孩子的英语阅读能力"),
    LV4(DataConstants.CONSTANT_FOUR, "4","适合提升国内小学3-4年级孩子的英语阅读能力"),
    LV5(DataConstants.CONSTANT_FIVE, "5","适合提升国内小学4-5年级孩子的英语阅读能力"),
    LV6(DataConstants.CONSTANT_SIX, "6","适合提升国内小学5-6年级孩子的英语阅读能力"),
    LV7(DataConstants.CONSTANT_SEVEN, "7","适合提升国内小学6年级-初中1年级孩子的英语阅读能力"),
    LV8(DataConstants.CONSTANT_EIGHT, "8","适合提升国内小学6年级-初中3年级孩子的英语阅读能力");

    int id;

    String code;
    String desc;

    private LevelEnum(int id, String code,String desc) {
        this.id = id;
        this.code = code;
        this.desc = desc;
    }

    public int getId() {
        return id;
    }

    public String getCode() {
        return code;
    }

    public String getDesc(){
        return desc;
    }
    public static LevelEnum ofCode(String code) {
        for (LevelEnum e : LevelEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }

    public static LevelEnum ofId(int id) {
        for (LevelEnum e : LevelEnum.values()) {
            if (e.getId() == id) {
                return e;
            }
        }
        return null;
    }

    public boolean equealTo(String code) {
        return this.equals(LevelEnum.ofCode(code));
    }

    public boolean equealTo(int id) {
        return this.equals(LevelEnum.ofId(id));
    }

    public static String getDesc(String code){
        for (LevelEnum e : LevelEnum.values()) {
            if (e.getCode().equals(code)) {
                return e.desc;
            }
        }
        return null;
    }
}
