package com.ella.resource.constants;

/**
 * @author Libin
 */
public interface DataEnum {
    int TYPE_COURSE_VALUE = DataConstants.CONSTANT_ONE;
    int TYPE_EXAM_VALUE = DataConstants.CONSTANT_THREE;
    int TYPE_TEST_VALUE = DataConstants.CONSTANT_TWO;
    int TYPE_LEXILE_VALUE = DataConstants.CONSTANT_FOUR;
    int TYPE_HIDE_VALUE = DataConstants.CONSTANT_ZERO;

    /**
     * 关卡类型 0：神秘关卡 1:课程  2:阶段性测验 3:考试  4：蓝思评测
     */
    enum MissionType {
        /**
         * 课程
         */
        TYPE_COURSE("cource", TYPE_COURSE_VALUE),
        /**
         * 考试
         */
        TYPE_EXAM("exam", TYPE_EXAM_VALUE),
        /**
         * 测试
         */
        TYPE_TEST("test", TYPE_TEST_VALUE),
        /**
         * 蓝思评测
         */
        TYPE_LEXILE("lexile", TYPE_LEXILE_VALUE),
        /**
         * 隐藏关卡
         */
        TYPE_HIDE("hide", TYPE_HIDE_VALUE);
        private String type;

        private Integer typeValue;

        MissionType(String type, Integer typeValue) {
            this.type = type;
            this.typeValue = typeValue;
        }

        public String getType() {
            return type;
        }

        public Integer getTypeValue() {
            return typeValue;
        }
    }

    /**
     * 非绘本 (0：未解锁   1：已解锁   2：已下架)
     */
    enum PicGalleryStatusType {
        /**
         * 非绘本状态
         */
        TYPE_PASS(DataConstants.CG_STATUS_PASS, 1),
        TYPE_NOT_STARTED(DataConstants.CG_STATUS_NOT_STARTED, 0),
        TYPE_UNLOCKED(DataConstants.UNLOCKED_STATUS, 1),
        TYPE_LOCKED(DataConstants.LOCKED_STATUS, 0),
        TYPE_DOING(DataConstants.CG_STATUS_DOING, 1),
        TYPE_SOLD_OUT("OVER_SALE", 2),
        ;
        private String type;

        private Integer typeValue;

        PicGalleryStatusType(String type, Integer typeValue) {
            this.type = type;
            this.typeValue = typeValue;
        }

        public static Integer getTypeValueByType(String type) {
            for (PicGalleryStatusType item : PicGalleryStatusType.values()) {
                if (item.getType().equals(type)) {
                    return item.getTypeValue();
                }
            }
            return 0;
        }

        public String getType() {
            return type;
        }

        public Integer getTypeValue() {
            return typeValue;
        }
    }

    /**
     * 绘本   (0未解锁,  1未完成，2已完成，3已下架)
     */
    enum PicGalleryBookStatusType {
        /**
         * 绘本状态
         */
        BOOK_TYPE_UNLOCKED(DataConstants.LOCKED_STATUS, 0),
        BOOK_TYPE_UN_FINISHED(DataConstants.CG_STATUS_NOT_STARTED, 1),
        BOOK_TYPE_FINISHED(DataConstants.CG_STATUS_PASS, 2),
        BOOK_TYPE_SOLD_OUT("OVER_SALE", 3),
        ;
        private String type;

        private Integer typeValue;

        PicGalleryBookStatusType(String type, Integer typeValue) {
            this.type = type;
            this.typeValue = typeValue;
        }

        public static Integer getTypeValueByType(String type) {
            for (PicGalleryBookStatusType item : PicGalleryBookStatusType.values()) {
                if (item.getType().equals(type)) {
                    return item.getTypeValue();
                }
            }
            return 0;
        }

        public String getType() {
            return type;
        }

        public Integer getTypeValue() {
            return typeValue;
        }
    }

    /**
     * 资源使用表--资源类型(课程：COURSE，绘本PICTUREBOOK,题库：QUESTION,考试：EXAM,测试：TEST)
     */
    enum RO_ResType {
        /**
         * 资源类型
         */
        Res_COURSE("COURSE", 1),
        Res_PICTURE_BOOK("PICTUREBOOK", 0),
        Res_QUESTION("QUESTION", 999),
        Res_EXAM("EXAM", 3),
        Res_TEST("TEST", 2);

        private String type;

        private Integer value;

        RO_ResType(String type, Integer value) {
            this.type = type;
            this.value = value;
        }

        public static String getType(Integer value) {
            for (RO_ResType item : RO_ResType.values()) {
                if (item.getValue().equals(value)) {
                    return item.getType();
                }
            }
            return "";
        }

        public String getType() {
            return type;
        }

        public Integer getValue() {
            return value;
        }
    }

    /**
     * 资源使用表--占用着类型(课程：COURSE，绘本馆PICTUREBOOK,考试：EXAM,测试：TEST,关卡：MISSION)
     */
    enum RO_OccupantType {
        /**
         * 占用着类型
         */
        Occupant_COURSE("COURSE"),
        Occupant_PICTURE_BOOK("PICTUREBOOK"),
        Occupant_MISSION("MISSION"),
        Occupant_EXAM("EXAM"),
        Occupant_TEST("TEST");

        private String type;

        RO_OccupantType(String type) {
            this.type = type;
        }

        public String getType() {
            return type;
        }
    }

    /**
     * 课程进度--课堂模式 CLASSROOM ，自学模式 SELF-STUDY，测验 TEST
     */
    enum CourseProcess {
        /**
         * 课堂模式
         */
        CLASSROOM("COURSE"),
        SELF_STUDY("SELF-STUDY"),
        TEST("TEST");

        private String type;

        CourseProcess(String type) {
            this.type = type;
        }

        public String getType() {
            return type;
        }
    }

    enum ActivityTypeEnum {
        /**
         * 活动类型
         */
        H5("H5", "H5送书活动"),
        TEM_H5("TEM_H5", "定制模板H5送书活动"),
        DIRECTIONAL("DIRECTIONAL", "定向送书"),
        CHANNEL("CHANNEL", "渠道送书"),
        REGISTER("REGISTER", "注册送书");

        private final String code;

        private final String msg;


        ActivityTypeEnum(String code, String msg) {
            this.code = code;
            this.msg = msg;
        }


        public String msg() {
            return this.msg;
        }

        public static ActivityTypeEnum getEnumByCode(String code) {
            for (ActivityTypeEnum retCodeEnum : ActivityTypeEnum.values()) {
                if (retCodeEnum.code.equals(code)) {
                    return retCodeEnum;
                }
            }
            return null;
        }


        public String getCode() {
            return code;
        }


        public String getMsg() {
            return msg;
        }
    }


    /**
     * 能量石赠送类型类型(关卡资源替换：MISSION_RESOURCE_REPLACE 插入过关状态关卡：MISSION_INSERT_PASS)
     */
    enum GIVE_STONE_TYPE {
        /**
         * 资源类型
         */
        MISSION_RESOURCE_REPLACE("MISSION_RESOURCE_REPLACE"),
        MISSION_INSERT_PASS("MISSION_INSERT_PASS");

        private String value;

        GIVE_STONE_TYPE(String value) {
            this.value = value;
        }


        public String getValue() {
            return value;
        }
    }

    String SYS_RESOURCE_UPDATE = "SYS_RESOURCE_UPDATE";

    /**
     * 系统资源变更类型
     */
    enum SYS_RESOURCE_UPDATE_TYPE {
        /**
         * 资源类型
         */
        /**
         * 关卡新增
         */
        MISSION_RESOURCE_INSERT("MISSION_RESOURCE_INSERT"),
        /**
         * 关卡资源替换
         */
        MISSION_RESOURCE_REPLACE("MISSION_RESOURCE_REPLACE"),
        /**
         * 关卡删除
         */
        MISSION_RESOURCE_DEL("MISSION_RESOURCE_DEL"),
        /**
         * 地图插入
         */
        MAP_RESOURCE_INSERT("MAP_RESOURCE_INSERT");

        private String value;

        SYS_RESOURCE_UPDATE_TYPE(String value) {
            this.value = value;
        }


        public String getValue() {
            return value;
        }
    }

    /**
     * 系统资源类型
     */
    enum SYS_RESOURCE_TYPE {
        /**
         * 资源类型
         */
        /**
         * 关卡
         */
        MISSION("MISSION"),
        /**
         * 地图
         */
        MAP("MAP"),
        LEVEL("LEVEL");

        private String value;

        SYS_RESOURCE_TYPE(String value) {
            this.value = value;
        }


        public String getValue() {
            return value;
        }
    }

    /**
     * 图书上下架状态  SHELVES_ON :上架 ,SHELVES_OFF :下架
     */
    enum SHELVESFLAG {
        /**
         * 资源类型
         */
        /**
         * 关卡
         */
        SHELVES_ON("SHELVES_ON"),
        /**
         * 地图
         */
        SHELVES_OFF("SHELVES_OFF");

        private String value;

        SHELVESFLAG(String value) {
            this.value = value;
        }


        public String getValue() {
            return value;
        }
    }


    enum UserTouchNotifyEnum {
        /**
         * 单词本查看类型
         */
        CATEGORY("CATEGORY", "类别"),
        WORD("WORD", "单词");

        private final String code;

        private final String msg;


        UserTouchNotifyEnum(String code, String msg) {
            this.code = code;
            this.msg = msg;
        }

        public String getCode() {
            return code;
        }


        public String getMsg() {
            return msg;
        }
    }

    enum WordSourceEnum {
        /**
         * 单词本来源类别
         */
        BASE("base", "基础单词"),
        KNOW("know", "猜你不认识"),
        COLLECT("collect", "我的收藏"),
        SEARCH("search","搜索"),
        CLICK("click","分词模式点击"),
        FOLLOW("follow", "我的跟读");

        private final String code;

        private final String msg;


        WordSourceEnum(String code, String msg) {
            this.code = code;
            this.msg = msg;
        }

        public String getCode() {
            return code;
        }


        public String getMsg() {
            return msg;

        }
    }
}
