package com.ella.resource.constants;

/**
 * @author LiBin
 */
public interface DataConstants {

    int CONSTANT_ZERO = 0;
    int CONSTANT_ONE = 1;
    int CONSTANT_TWO = 2;
    int CONSTANT_THREE = 3;
    int CONSTANT_FOUR = 4;
    int CONSTANT_FIVE = 5;
    int CONSTANT_SIX = 6;
    int CONSTANT_SEVEN = 7;
    int CONSTANT_EIGHT = 8;
    int CONSTANT_NINE = 9;
    int CONSTANT_TEN = 10;

    /**
     * 数据状态正常
     */
    String DATA_STATUS_NORMAL = "NORMAL";

    /**
     * 数据状态已删除
     */
    String DATA_STATUS_DELETED = "DELETE";

    /**
     * 数据状态异常
     */
    String DATA_STATUS_EXCEPTION = "EXCEPTION";

    /**
     * 等级状态--确认
     */
    int LEVEL_USER_STATUS_SURE = CONSTANT_TWO;

    /**
     * 等级状态--待确认
     */
    int LEVEL_USER_STATUS_UNSURE = CONSTANT_ZERO;

    /**
     * 等级状态--修改中
     */
    int LEVEL_USER_STATUS_MODIFYING = CONSTANT_ONE;

    String STR_STATUS_SURE = "SURE";

    String STR_STATUS_UNSURE = "UNSURE";

    /**
     * 地图资源类型--动效
     */
    String MAP_RESOURCE_DYNAMIC = "dynamic";

    /**
     * 地图资源类型--关卡图标
     */
    String MAP_RESOURCE_ICO = "ico";

    /**
     * 地图资源类型--背景
     */
    String MAP_RESOURCE_BACKGROUND = "background";

    /**
     * 使用状态-已使用
     */
    String STATUS_Y = "Y";

    /**
     * 使用状态-未使用
     */
    String STATUS_N = "N";

    /**
     * 闯关状态-已过关
     */
    String CG_STATUS_PASS = "PASS";

    /**
     * 闯关状态-进行中
     */
    String CG_STATUS_DOING = "DOING";

    /**
     * 闯关状态-未开始
     */
    String CG_STATUS_NOT_STARTED = "NOTSTARTED";

    /**
     * 已解锁状态
     */
    String UNLOCKED_STATUS = "UNLOCKED";

    /**
     * 未解锁状态
     */
    String LOCKED_STATUS = "LOCKED";

    /**
     * 绘本弹窗的缓存key前缀
     */
    String PIC_BOOK_POPUP_REDIS_KEY_PREFIX = "PIC_BOOK_POPUP:";

    /**
     * 体验弹窗的缓存key前缀
     */
    String EXPERIENCE_POPUP_REDIS_KEY_PREFIX = "EXPERIENCE_POPUP:";

    /**
     * 地图资源包的缓存key前缀
     */
    String MAP_RESOURCE_PACKAGE_KEY = "MAP_RESOURCE:";

    /**
     * 修改排序的操作类型-向上
     */
    String OPERATE_TYPE_UP = "up";

    /**
     * 修改排序的操作类型-向下
     */
    String OPERATE_TYPE_DOWN = "down";

    /**
     * 分隔符-分号
     */
    String SEPARATOR_SEMICOLON=";";

    /**
     * 分隔符-逗号
     */
    String SEPARATOR_COMMA=",";

    /**
     * 分隔符-井号
     */
    String SEPARATOR_COMMENTS="#";

    String COIN_TYPE = "COIN";
    String MAP_MEMBER_TYPE = "MAP_MEMBER";

    /**月卡会员*/
    String USER_VIP_MONTH = "ellabook3monthcard98";
    /**年卡会员*/
    String USER_VIP_YEAR = "ellabook3yearcard698";

    /**连续包月会员*/
//    String USER_VIP_AUTO_MONTH = "ellabook3automonthcard98";
    /**连续包年会员*/
//    String USER_VIP_AUTO_YEAR = "ellabook3autoyearcard698";

    String BOOK_TYPE_BUY ="BUY";
    String BOOK_TYPE_COMMAND="COMMAND";
    String BOOK_TYPE_ALL ="ALL";

    /**
     * 运营工具后台调整显示顺序idx，向下，向上，置顶
     */
    String BACK = "back";
    String FORWARD = "forward";
    String TOP = "top";

    /**
     * 英语商品缓存前缀
     */
    String BOE_GOODS_BOOK_EN = "BOE:GOODS:BOOK:EN:";

    String YES = "YES";
    String NO = "NO";

    /**
     * 孩子uid为基本单位存储IRA阅读报告所需要的数据状态，有值则数据未改变，不需要更新报告，无值，则数据改变，需要更新报告
     */
    String BOE_EN_IRA_REPORT = "BOE:EN:IRA:REPORT:";


    String BOE_EN_IRA_LOCK_KEY = "BOE:EN:IRA:LOCK_KEY:";
    /**
     * 英语cid换uid
     */
    String EN_CID_UID = "EN:CID:UID:";
    String EN_MISSIONCODE_MAPCODE = "BOE:EN:MISSIONCODE:MAPCODE:";
    /**
     * IRA用地图缓存数据
     */
    String EN_MAP_INFO="EN_MAP_INFO:";
    /**
     * 用户有阅读报告的地图code集合
     */
    String EN_IRA_MAP_CODE="BOE:EN:IRA:MAP_CODE:";
    String EN_IRA_REP_CODE="BOE:EN:IRA:REP_CODE:";
    String EN_IRA_MAP_MISSION_NUM="BOE:EN:IRA:MAP_MISSION_NUM:";
    int EN_IRA_MAP_CODE_EXPIRE_TIME = 15 * 60;

    /**
     * 记录用户当天是否第一次生成阅读报告
     */
    String EN_IRA_REPORT_CODE="BOE:EN:IRA:REPORT_CODE:";
    /**
     * 用户在指定map的IRA阅读报告
     */
    String EN_IRA_REPORT_DATA="BOE:EN:IRA:REPORT:DATA:";
    /**
     * 猜你不认识 用户跟读分数标准
     */
    Integer LIMIT_SCORE = 80;

     /**
     * DB缓存前缀
     */
    String DB_RESOURCE = "db_resource_";
    String SERVICE_RESOURCE = "service_resource_";
    String CACHE_LEVEL_ONE = "one";
    String CACHE_LEVEL_TWO = "two";

    /**
     * 单词本excel上传单词，解析后临时存储于redis用
     */
    String BOE_EN_WORD_LIST_ERROR = "BOE:EN:LIST:ERROR:";
    String BOE_EN_WORD_LIST_CHANGED = "BOE:EN:LIST:CHANGED:";
    String BOE_EN_WORD_LIST_ILLEGAL = "BOE:EN:LIST:ILLEGAL:";
    String BOE_EN_WORD_LIST_SAVE = "BOE:EN:LIST:SAVE:";
    /**
     * 2019-06-30 24点前特殊功能使用
     */
    String FREE_GOODS_VERSION = "free_goods_version";
    String FREE_USER_BOOK_VERSION = "free_user_book_version_";

    String MISSION_RES_UPDATE_TIME = "mission_res_update_time_";
}
