package com.ella.resource.constants;

import javax.validation.constraints.NotNull;

/**
 * 课程模式中的答题结果
 *
 * @author Libin
 */
public enum CourseResultEnum   {
    /**
     * 答题结果
     */
    DEFAULT(DataConstants.CONSTANT_ZERO, "default"),
    GOOD(DataConstants.CONSTANT_ONE, "good"),
    GREAT(DataConstants.CONSTANT_TWO, "great"),
    PERFECT(DataConstants.CONSTANT_THREE, "perfect");

    int id;

    String code;

    CourseResultEnum(int id, String code) {
        this.id = id;
        this.code = code;
    }

    public int getId() {
        return id;
    }

    public String getCode() {
        return code;
    }

    public static CourseResultEnum ofCode(String code) {
        for (CourseResultEnum e : CourseResultEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return CourseResultEnum.DEFAULT;
    }

    public static CourseResultEnum ofId(int id) {
        for (CourseResultEnum e : CourseResultEnum.values()) {
            if (e.getId() == id) {
                return e;
            }
        }
        return CourseResultEnum.DEFAULT;
    }
}
