package com.ella.resource.config;

import com.alibaba.fastjson.JSONObject;
import com.ella.frame.common.util.Base64Util;
import com.ella.frame.common.util.HeadParamTl;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.util.Optional;

/**
 * http请求头的公共参数获取工具
 *
 * @author LiBin
 * @email libin@ellabook.cn
 * @date 2018-09-04 11:37
 **/
@Log4j2
public class HeadParamUtil {

    private static final String EMPTY = "";

    //如果需要缓存，以后再开启
    //private static final ConcurrentMap<String, HeadParamTl> cachedHeadParamTl = new ConcurrentHashMap<String, HeadParamTl>();

    /**
     * 获取请求头的公共参数{@link HeadParamTl}<br/>
     *
     * @return {@link HeadParamTl}不会返回null
     */
    public static HeadParamTl getHeadParamTl() {

        HeadParamTl headParamTl = new HeadParamTl();

        HttpServletRequest request = getHttpServletRequest();
        String enHeadParam = getStrFromBase64(request.getHeader(HeadParamTl.HEAD_PARAM_NAME));
        if (StringUtils.isBlank(enHeadParam)) {
            return headParamTl;
        }

        try {
            headParamTl = JSONObject.parseObject(enHeadParam, HeadParamTl.class);
            log.info("method HeadParamUtil.getHeadParamTl result:{}", headParamTl.toString());
        } catch (Exception e) {
            return headParamTl;
        }
        return headParamTl;
    }

    private static HttpServletRequest getHttpServletRequest() {
        ServletRequestAttributes requestAttributes =
                (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        return requestAttributes.getRequest();
    }

    public static String getAuthorization() {
        return  Optional.ofNullable(getHttpServletRequest().getHeader("Authorization")).orElse("");
    }

    private static String getStrFromBase64(String header) {
        if (StringUtils.isBlank(header)) {
            return EMPTY;
        }
        try {
            return Base64Util.decodeBase64StrNew(header);
        } catch (IllegalArgumentException | UnsupportedEncodingException ie) {
            return EMPTY;
        }
    }

    /**
     * 获取渠道号
     *
     * @return 渠道号，不会返回null
     */
    public static String getChannelCode() {
        return Optional.ofNullable(getHeadParamTl().getChannelCode()).orElse(EMPTY);
    }

    /**
     * 获取客户端标识
     *
     * @return 客户端标识，不会返回null
     */
    public static String getClientRole() {
        return Optional.ofNullable(getHeadParamTl().getClientRole()).orElse(EMPTY);
    }

    /**
     * 获取客户端类型
     *
     * @return 客户端类型，不会返回null
     */
    public static String getClientType() {
        return Optional.ofNullable(getHeadParamTl().getClientType()).orElse(EMPTY);
    }

    /**
     * 获取设备码
     *
     * @return 设备码，不会返回null
     */
    public static String getDeviceNo() {
        return Optional.ofNullable(getHeadParamTl().getDeviceNo()).orElse(EMPTY);
    }

    /**
     * 获取客户端型号
     *
     * @return 客户端型号，不会返回null
     */
    public static String getResource() {
        return Optional.ofNullable(getHeadParamTl().getResource()).orElse(EMPTY);
    }

}
