package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.request.AddWordReq;
import com.ella.resource.dto.request.SelectWordReq;
import com.ella.resource.dto.request.app.PutUserWordWallRequest;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


/**
 * @author ZLN
 * @create 2018-08-01 16:17
 **/
@FeignClient("en-resource-service")
public interface WordWallService {

    @RequestMapping(value = "expotExcle/v1", method = RequestMethod.GET)
    ResponseParams<List<List<String>>> expotExcle();

    @RequestMapping(value = "addWord/v1", method = RequestMethod.POST)
    ResponseParams addWord(@RequestBody AddWordReq req);

    @RequestMapping(value = "selectWord/V1", method = RequestMethod.POST)
    ResponseParams selectWord(@RequestBody SelectWordReq req);

    @RequestMapping(value = "addBachWordStr/V1", method = RequestMethod.POST)
    ResponseParams<?> addBachWordStr(@RequestParam("contentsJson") String contentsJson);

    ///**
    // * 获取用户的单词墙
    // *
    // * @param uid uid
    // * @return List<UserWordWallDto> {@link UserWordWallDto}
    // */
    //@RequestMapping(value = "getUserWordWall/V1", method = RequestMethod.POST)
    //ResponseParams<List<UserWordWallDto>> getUserWordWall(String uid);

    /**
     * 用户收藏单词到单词墙
     *
     * @param request {@link PutUserWordWallRequest}
     * @return Boolean
     */
    @RequestMapping(value = "putUserWordWall/V1", method = RequestMethod.POST)
    ResponseParams<Boolean> putUserWordWall(@RequestBody PutUserWordWallRequest request);
}
