package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.ResponsePageResult;
import com.ella.resource.dto.WordCategoryDto;
import com.ella.resource.dto.WordListDto;
import com.ella.resource.dto.request.WordCategoryReq;
import com.ella.resource.dto.request.WordListReq;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;
import java.util.Map;


/**
 * @author mengyang
 * @create 2019.12.02
 **/
@FeignClient("boeen-resource-service")
public interface WordListService {

    @RequestMapping(value = "ListCategoriesByLevel/v1", method = RequestMethod.POST)
    ResponseParams<ResponsePageResult> listCategoriesByLevel(@RequestBody WordCategoryReq wordCategoryReq);

    @RequestMapping(value = "ListSimpleCategoriesByLevel/v1", method = RequestMethod.POST)
    ResponseParams<List<Map>> listSimpleCategoriesByLevel(@RequestBody WordCategoryReq wordCategoryReq);

    @RequestMapping(value = "showCategoryByCode/v1", method = RequestMethod.POST)
    ResponseParams<WordCategoryDto> showCategoryByCode(@RequestBody WordCategoryReq wordCategoryReq);

    @RequestMapping(value = "updateCategory/v1", method = RequestMethod.POST)
    ResponseParams<String> updateCategory(@RequestBody WordCategoryReq wordCategoryReq);

    @RequestMapping(value = "updateCategoryIdx/v1", method = RequestMethod.POST)
    ResponseParams<String> updateCategoryIdx(@RequestBody WordCategoryReq wordCategoryReq);

    @RequestMapping(value = "insertCategory/v1", method = RequestMethod.POST)
    ResponseParams<String> insertCategory(@RequestBody WordCategoryReq wordCategoryReq);

    @RequestMapping(value = "searchCategory/v1", method = RequestMethod.POST)
    ResponseParams<ResponsePageResult> searchCategory(@RequestBody WordCategoryReq wordCategoryReq);

    @RequestMapping(value = "insertWord/v1", method = RequestMethod.POST)
    ResponseParams<String> insertWord(@RequestBody WordListReq req);

    @RequestMapping(value = "checkWordExist/v1", method = RequestMethod.POST)
    ResponseParams<String> checkWordExist(@RequestBody WordListReq req);

    @RequestMapping(value = "updateWord/v1", method = RequestMethod.POST)
    ResponseParams<String> updateWord(@RequestBody WordListReq req);

    @RequestMapping(value = "searchWord/v1", method = RequestMethod.POST)
    ResponseParams<List<String>> searchWord(@RequestBody WordListReq req);

    @RequestMapping(value = "showOneWordMsg/v1", method = RequestMethod.POST)
    ResponseParams<WordListDto> showOneWordMsg(@RequestBody WordListReq req);

    @RequestMapping(value = "listWordsByRelationCode/v1", method = RequestMethod.POST)
    ResponseParams<ResponsePageResult> listWordsByRelationCode(@RequestBody WordListReq req);

    @RequestMapping(value = "updateWordIdx/v1", method = RequestMethod.POST)
    ResponseParams<String> updateWordIdx(@RequestBody WordListReq req);
}
