package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.request.WordListImportReq;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

/**
 * @author mengyang
 * @create 2019.12.02
 **/
@FeignClient("boeen-resource-service")
public interface WordListImportService {

    @RequestMapping(value = "importWordListExcel/v1", method = RequestMethod.POST, consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    ResponseParams<String> importWordListExcel(@RequestPart(value = "file", required = false) MultipartFile file);

    @RequestMapping(value = "importWordListToDb/v1", method = RequestMethod.POST)
    ResponseParams<String> importWordListToDb(@RequestBody WordListImportReq req);
}
