package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.pass.SetLevelMissionRequest;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author:wangshuzheng
 * @date:2019/8/23 下午3:35
 * @des:白名单用户脚本
 */
@FeignClient("en-resource-service")
public interface WhiteUserService {
    /**
     * 将所以地图和关卡资源快照给mobile对应的用户/en/order/createMapMemberOrder/v1
     * @param mobile 用户手机号
     * @return
     */
    @RequestMapping(value = "/v1/white-user/snapAll", method = RequestMethod.POST)
    ResponseParams<Boolean> snapAll(@RequestParam(value = "uid",required = false) String uid,@RequestParam(value = "mobile",required = false) String mobile,@RequestParam(value = "levelCode",required = false) String levelCode);
    /**
     * @author wangshuzheng
     * @date 2019/8/23 下午6:19
     * @param mobile 用户手机号
     * @param day 开通会员天数
     * des 脚本接口 将指定用户（iphone用户）开通指定天数的会员
    */
    @RequestMapping(value = "/v1/white-user/buyAppleVip", method = RequestMethod.POST)
    ResponseParams<Boolean> buyAppleVip(@RequestParam("mobile") String mobile,@RequestParam("day") Integer day);

    @RequestMapping(value = "/v1/white-user/setLevelMission", method = RequestMethod.POST)
    ResponseParams setLevelMission(@RequestBody SetLevelMissionRequest request);
}
