package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.word.*;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author:wangshuzheng
 * @date:2019/12/9 上午11:22
 * @des:单词本APP 业务接口方法
 */
@FeignClient("en-resource-service")
public interface UserWordService {
    /**
     * 类别列表
     * @param request
     * @return
     */
    @RequestMapping(value = "/userWord/wordCategories/v1", method = RequestMethod.POST)
    ResponseParams wordCategories(@RequestBody WordCategoriesRequest request);

    /**
     * 单词列表
     * @param request
     * @return
     */
    @RequestMapping(value = "/userWord/wordList/v1", method = RequestMethod.POST)
    ResponseParams wordList(@RequestBody WordListRequest request);

    /**
     * 用户查看单词通知
     * @param request
     * @return
     */
    @RequestMapping(value = "/userWord/userTouchNotify/v1", method = RequestMethod.POST)
    ResponseParams userTouchNotify(@RequestBody UserTouchNotifyRequest request);

    /**
     * 搜索单词
     * @param request
     * @return
     */
    @RequestMapping(value = "/userWord/searchWordList/v1", method = RequestMethod.POST)
    ResponseParams searchWordList(@RequestBody SearchWordListRequest request);

    /**
     * 收藏单词
     * @param request
     * @return
     */
    @RequestMapping(value = "/userWord/collectUserWord/v1", method = RequestMethod.POST)
    ResponseParams collectUserWord(@RequestBody CollectUserWordRequest request);

    /**
     * 认识单词
     * @param request
     * @return
     */
    @RequestMapping(value = "/userWord/knowUserWord/v1", method = RequestMethod.POST)
    ResponseParams knowUserWord(@RequestBody KnowUserWordRequest request);

    /**
     * 单词详情
     * @param request
     * @return
     */
    @RequestMapping(value = "/userWord/userWordDetail/v1", method = RequestMethod.POST)
    ResponseParams userWordDetail(@RequestBody UserWordDetailRequest request);

    /**
     * 获取用户单词跟读记录
     * @param request
     * @return
     */
    @RequestMapping(value = "/userWord/getUserWordFollow/v1", method = RequestMethod.POST)
    ResponseParams getUserWordFollow(@RequestBody UserWordFollowRequest request);

    /**
     * 保存用户单词跟读记录
     * @param request
     * @return
     */
    @RequestMapping(value = "/userWord/saveUserWordFollow/v1", method = RequestMethod.POST)
    ResponseParams saveUserWordFollow(SaveUserWordFollowRequest request);

    /**
     * 判断单词是否已经收藏
     * @param request
     * @return
     */
    @RequestMapping(value = "/userWord/judgeCollect/v1", method = RequestMethod.POST)
    ResponseParams judgeCollect(JudgeCollectRequest request);
}
