package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.sendgoods.SendGoodsToUserRequest;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 用户发货服务
 */
@FeignClient("en-resource-service")
public interface UserSendGoodsService {

    /**
     * 根据类型发货给用户
     */
    @RequestMapping(value = "/v1/userSendGoods/sendGoodsToUser", method = RequestMethod.POST)
    ResponseParams<Boolean> sendGoodsToUser(@RequestBody SendGoodsToUserRequest req);

}
