package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.appdto.CourseMissionDto;
import com.ella.resource.dto.appdto.PicBookMissionDto;
import com.ella.resource.dto.appdto.UserMapListDto;
import com.ella.resource.dto.appdto.UserMissionListDto;
import com.ella.resource.dto.request.BaseRequest;
import com.ella.resource.dto.request.map.GetMapInfoRequest;
import com.ella.resource.dto.request.mission.GetMissionInfoRequest;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 用户地图和关卡服务-快照方式
 *
 * @author Libin
 */
@FeignClient("en-resource-service")
public interface UserMapAndMissionSnapshotService {

    /**
     * 获取用户地图
     *
     * @param request request
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/map/selectUserMap", method = RequestMethod.POST)
    ResponseParams<List<UserMapListDto>> selectUserMap(@RequestBody BaseRequest request);

    /**
     * 获取用户关卡
     *
     * @param request GetMapInfoRequest
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/mission/selectUserMission", method = RequestMethod.POST)
    ResponseParams<UserMissionListDto> selectUserMission(@RequestBody GetMapInfoRequest request);

    /**
     * 获取用户课程关卡详情
     *
     * @param request GetMissionInfoRequest
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/mission/userMissionInfo", method = RequestMethod.POST)
    ResponseParams<CourseMissionDto> userMissionInfo(@RequestBody GetMissionInfoRequest request);


    /**
     * 获取用户绘本关卡详情
     *
     * @param request GetMissionInfoRequest
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/mission/userPicMissionInfo", method = RequestMethod.POST)
    ResponseParams<PicBookMissionDto> userPicMissionInfo(@RequestBody GetMissionInfoRequest request);

    /**
     * 判断当前关卡是否可点击
     */
    @RequestMapping(value = "/v1/mission/missionClickable", method = RequestMethod.POST)
    Boolean missionClickable(@RequestParam("uid") String uid, @RequestParam("currentMissionId") Long currentMissionId,
                             @RequestParam("levelCode") String levelCode, @RequestParam("type") String type);
}
