package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.appdto.*;
import com.ella.resource.dto.missiondto.NextMissionInfoDto;
import com.ella.resource.dto.request.BaseRequest;
import com.ella.resource.dto.request.map.GetMapInfoRequest;
import com.ella.resource.dto.request.mission.GetMissionInfoRequest;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 用户地图和关卡服务
 *
 * @author Libin
 */
@FeignClient("en-resource-service")
public interface UserMapAndMissionService {

    /**
     * 获取用户地图
     * Deprecated by LiBin on 20190625 采用快照版本
     *
     * @param request request
     * @return ResponseParams
     * @see UserMapAndMissionSnapshotService
     */
    @Deprecated
    @RequestMapping(value = "/v1/map/selectUserMap-bak", method = RequestMethod.POST)
    ResponseParams<List<UserMapListDto>> selectUserMap(@RequestBody BaseRequest request);

    /**
     * 蓝思评级后，修改用户地图信息
     *
     * @param afterLexilePassDto AfterLexilePassDto
     */
    @RequestMapping(value = "/v1/map/updateUserMapAfterLexileTest", method = RequestMethod.POST)
    void updateUserMapAfterLexileTest(@RequestBody AfterLexilePassDto afterLexilePassDto);

    /**
     * 获取用户关卡
     * Deprecated by LiBin on 20190625 采用快照版本
     *
     * @param request GetMapInfoRequest
     * @return ResponseParams
     * @see UserMapAndMissionSnapshotService
     */
    @Deprecated
    @RequestMapping(value = "/v1/mission/selectUserMission-bak", method = RequestMethod.POST)
    ResponseParams<UserMissionListDto> selectUserMission(@RequestBody GetMapInfoRequest request);

    /**
     * 获取用户课程关卡详情
     *
     * @param request GetMissionInfoRequest
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/mission/userMissionInfo-bak", method = RequestMethod.POST)
    ResponseParams<CourseMissionDto> userMissionInfo(@RequestBody GetMissionInfoRequest request);


    /**
     * 获取用户绘本关卡详情
     *
     * @param request GetMissionInfoRequest
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/mission/userPicMissionInfo-bak", method = RequestMethod.POST)
    ResponseParams<PicBookMissionDto> userPicMissionInfo(@RequestBody GetMissionInfoRequest request);

    /**
     * 1，新增用户后的添加免费试用地图。<br/>
     * 2，充值会员时，对未评测的用户，添加第一个地图的全部关卡
     *
     * @param uid     uid
     * @param vipFlag Y是N否
     */
    @RequestMapping(value = "/v1/map/updateUserMapForFree", method = RequestMethod.POST)
    void updateUserMapForFree(@RequestParam("uid") String uid, @RequestParam("vipFlag") String vipFlag);

    /**
     * 考试/课程 or 其他测验通过 快照下一个地图资源
     */
    @RequestMapping(value = "/v1/map/updateUserMapAfterTest", method = RequestMethod.POST)
    NextMissionInfoDto updateUserMapAfterTest(@RequestParam("levelCode") String levelCode,@RequestParam("uid") String uid,@RequestParam("mapCode") String mapCode,@RequestParam("missionCode") String missionCode);

     /** 将所以地图和关卡资源快照给uid对应的用户 并设置为pass
     * @param uid 用户uid
     * @return
     */
    @RequestMapping(value = "/v1/map/snapAllUserResource", method = RequestMethod.POST)
    ResponseParams<Boolean> snapAll(@RequestParam("uid") String uid,@RequestParam("levelCode") String levelCode);
}
