package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.ResQuestionDto;
import com.ella.resource.dto.request.question.*;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author zhaoj
 *         题目  业务
 */
@FeignClient("en-resource-service")
public interface ResQuestionService {

    /**
     * 添加题目->zhaojl
     *
     * @param resQuestion
     * @return
     */
    @RequestMapping(value = "/v1/resquestion/insertResQuesition", method = RequestMethod.POST)
    ResponseParams<Boolean> insertResQuestion(SaveResQuestionRequest resQuestion);

    /**
     * 编辑题目->zhaojl
     *
     * @param page
     * @return
     */
    @RequestMapping(value = "/v1/resquestion/getAllQuestionInfo", method = RequestMethod.POST)
    ResponseParams<?> getAllResQuestionInfo(QueryResQuestionRequest page);

    /**
     * 获取题目(列表/条件)->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resquestion/deleteQuestionByIds", method = RequestMethod.POST)
    ResponseParams<Boolean> deleteResQuestion(DeleteResQuestionRequest request);

    /**
     * 按id查询题目详情->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resquestion/updateResQuesition", method = RequestMethod.POST)
    ResponseParams<Boolean> updateResQuestion(EditResQuestionRequest request);

    /**
     * 删除题目->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resquestion/getQuestionById", method = RequestMethod.POST)
    ResponseParams<ResQuestionDto> getQuestionById(DeleteResQuestionRequest request);

    /**
     * 获取过滤掉占用者后的题目列表->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resquestion/getResQuestionByOccupant", method = RequestMethod.POST)
    ResponseParams<?> getResQuestionByOccupant(QuestionsByOccupantTypeReq request);

}
