package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.ResPeriodTestDetailDto;
import com.ella.resource.dto.ResPeriodTestDto;
import com.ella.resource.dto.request.periodtest.*;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient("en-resource-service")
public interface ResPeriodTestService {

    /**
     * 添加阶段性测验->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resPeriodTest/insertResPeriodTest", method = RequestMethod.POST)
    ResponseParams<Boolean> saveResPeriodTest(SaveResPeriodTestRequest request);

    /**
     * 删除阶段性测验->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resPeriodTest/deleteResPeriodTest", method = RequestMethod.POST)
    ResponseParams<Boolean> deleteResPeriodTest(DeleteResPeriodTestRequest request);

    /**
     * 获取测验(列表/条件查询)->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resPeriodTest/getResPeriodTest", method = RequestMethod.POST)
    ResponseParams<?> getResPeriodTest(QueryResPeriodTestRequest request);

    /**
     * 编辑测验信息->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resPeriodTest/updateResPeriodTest", method = RequestMethod.POST)
    ResponseParams<Boolean> updateResPeriodTest(EditResPeriodTestRequest request);

    /**
     * 添加测验题目->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resPeriodTest/addPeriodTestDetail", method = RequestMethod.POST)
    ResponseParams<Boolean> addPeriodTestDetail(PeriodTestDetailListRequest request);

    /**
     * 删除阶段性测验题目->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resPeriodTest/RemoveQuestionRequest", method = RequestMethod.POST)
    ResponseParams<Boolean> removeQuestionRequest(RemoveQuestionRequest request);

    /**
     * 获取测验单个题目->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resPeriodTest/getResPeriodTestQuestion", method = RequestMethod.POST)
    ResponseParams<ResPeriodTestDetailDto> getResPeriodTestQuestion(QueryResPeriodTestQuestionRequest request);

    /**
     * 获取测验详情->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resPeriodTest/getResPeriodTestAllQuestion", method = RequestMethod.POST)
    ResponseParams<ResPeriodTestDto> getResPeriodTestAllQuestion(PeriodTestAllQuestionRequest request);

    /**
     * 阶段性测验题目移动->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resPeriodTest/updateTestQuestionOrder", method = RequestMethod.POST)
    ResponseParams<Boolean> updateTestQuestionOrder(OrderQuestionRequest request);

}
