package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.SaveResOccupantRequest;
import com.ella.resource.dto.request.DeleteResOccupantRequest;
import com.ella.resource.dto.request.ModifyResOccupantRequest;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient("en-resource-service")
public interface ResOccupantService {

    /**
     * 保存资源占用记录
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resOccupant/saveResOccupant", method = RequestMethod.POST)
    ResponseParams<Boolean> saveResOccupant(@RequestBody SaveResOccupantRequest request);

    /**
     * 删除资源占用记录
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resOccupant/deleteResOccupant", method = RequestMethod.POST)
    ResponseParams<Boolean> deleteResOccupant(@RequestBody DeleteResOccupantRequest request);

    /**
     * 修改资源占用记录
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resOccupant/modifyResOccupant", method = RequestMethod.POST)
    ResponseParams<Boolean> modifyResOccupant(@RequestBody ModifyResOccupantRequest request);
}
