package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.ResExamDetailDto;
import com.ella.resource.dto.ResExamDto;
import com.ella.resource.dto.request.exam.*;
import com.ella.resource.dto.request.periodtest.OrderQuestionRequest;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient("en-resource-service")
public interface ResExamService {

    /**
     * 添加考试->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resExam/saveResExam", method = RequestMethod.POST)
    ResponseParams<Boolean> saveResExam(SaveResExamRequest request);

    /**
     * 删除考试->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resExam/deleteResExam", method = RequestMethod.POST)
    ResponseParams<Boolean> deleteResExam(@RequestBody DeleteResExamRequest request);

    /**
     * 编辑考试->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resExam/updateResExam", method = RequestMethod.POST)
    ResponseParams<Boolean> updateResExam(EditResExamRequest request);

    /**
     * 查询考试(列表/条件查询)->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resExam/queryResExam", method = RequestMethod.POST)
    ResponseParams<?> queryResExam(QueryResExamRequest request);

    /**
     * 查询考试详情->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resExam/queryResExamDetail", method = RequestMethod.POST)
    ResponseParams<ResExamDto> queryResExamDetail(ResExamAllQuestionRequest request);

    /**
     * 添加考试习题->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resExam/saveResExamDetail", method = RequestMethod.POST)
    ResponseParams<Boolean> saveResExamDetail(SaveExamDetailListRequest request);


    /**
     * 添加考试习题属性->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resExam/addExamDetailProperty", method = RequestMethod.POST)
    ResponseParams<Boolean> addExamDetailProperty(AddExamDtailPropertyRequest request);

    /**
     * 删除考试习题->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resExam/deleteResExamDetail", method = RequestMethod.POST)
    ResponseParams<Boolean> deleteResExamDetail(DeleteResExamDetailRequest request);

    /**
     * 获取考试单个习题详->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resExam/queryExamDetailQuestion", method = RequestMethod.POST)
    ResponseParams<ResExamDetailDto> queryExamDetailQuestion(QueryResExamQuestionRequest request);

    /**
     * 考试题目上下移动->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/resExam/updateExamQuestionOrder", method = RequestMethod.POST)
    ResponseParams<Boolean> updateExamQuestionOrder(OrderQuestionRequest request);

}
