package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.PictureBookLevelRelDto;
import com.ella.resource.dto.PictureBookListDto;
import com.ella.resource.dto.request.picturebooklevel.AddPictureBookToLevelRequest;
import com.ella.resource.dto.request.picturebooklevel.SavePictureBookLevelRelRequest;
import com.ella.resource.dto.request.picturebooklevel.SortPictureBookRequest;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 绘本管理服务
 *
 * @author Libin
 */
@FeignClient("en-resource-service")
public interface PictureBookLevelRelService {
    /**
     * 绘本管理列表查询
     *
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/pictureBookLevelRel/getPictureBookLevelRelList", method = RequestMethod.POST)
    ResponseParams<List<PictureBookLevelRelDto>> getPictureBookLevelRelList();

    /**
     * 获取等级的绘本列表
     *
     * @param request request
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/pictureBookLevelRel/getPictureBookList", method = RequestMethod.POST)
    ResponseParams<List<PictureBookListDto>> getPictureBookList(@RequestBody SavePictureBookLevelRelRequest request);

    /**
     * 绘本管理新增
     *
     * @param request request
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/pictureBookLevelRel/savePictureBookLevelRel", method = RequestMethod.POST)
    ResponseParams<Integer> savePictureBookLevelRel(@RequestBody SavePictureBookLevelRelRequest request);

    /**
     * 绘本管理删除
     *
     * @param request request
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/pictureBookLevelRel/deletePictureBookLevelRel", method = RequestMethod.POST)
    ResponseParams<Boolean> deletePictureBookLevelRel(@RequestBody SavePictureBookLevelRelRequest request);

    /**
     * 添加绘本到等级中
     *
     * @param request request
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/pictureBookLevelRel/addPictureBookToLevel", method = RequestMethod.POST)
    ResponseParams<Boolean> addPictureBookToLevel(@RequestBody AddPictureBookToLevelRequest request);

    /**
     * 从等级中删除绘本
     *
     * @param id id
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/pictureBookLevelRel/deletePictureBookFromLevel", method = RequestMethod.GET)
    ResponseParams<Boolean> deletePictureBookFromLevel(@RequestParam("id") Integer id);

    /**
     * 绘本排序
     *
     * @param request request
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/pictureBookLevelRel/sortPictureBook", method = RequestMethod.POST)
    ResponseParams<Boolean> sortPictureBook(@RequestBody SortPictureBookRequest request);
}
