package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.PicBookStoreDto;

import com.ella.resource.dto.PictureBookDto;
import com.ella.resource.dto.getBookShelvesFlagDto;
import com.ella.resource.dto.request.*;
import com.ella.resource.dto.request.picturebook.GetPicBooksByCodeRequest;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.ArrayList;
import java.util.List;

/**
 * @author ZLN
 * @create 2018-07-31 10:15
 **/
@FeignClient("en-resource-service")
public interface PicBookService {
    @RequestMapping(value = "v1/levelAddPicBook", method = RequestMethod.POST)
    ResponseParams levelAddPicBook(@RequestBody PicBookListReq req);

    @RequestMapping(value = "v1/readRecord", method = RequestMethod.POST)
    ResponseParams readRecord(@RequestBody ReadRecordReq req);

    @RequestMapping(value = "addReadCount/v1", method = RequestMethod.POST)
    ResponseParams addReadCount(@RequestBody AddReadCountReq req);

    @RequestMapping(value = "getPicBookInfo/v1", method = RequestMethod.POST)
    ResponseParams getPicBookInfo(@RequestBody GetPicBookInfoReq req);

    @RequestMapping(value = "picBookStore/v1", method = RequestMethod.POST)
    ResponseParams picBookStore(@RequestBody PicBookStoreReq req);

    @RequestMapping(value = "picBookList/v1", method = RequestMethod.POST)
    ResponseParams picBookList(@RequestBody PicBookListReq req);

    @RequestMapping(value = "getInfoById/v1", method = RequestMethod.GET)
    ResponseParams getInfoById(@RequestParam("id") Integer id);

    @RequestMapping(value = "updatePicBook/v1", method = RequestMethod.POST)
    ResponseParams updatePicBook(@RequestBody AddPicBookReq res);

    /**
     * 查询绘本列表
     */
    @RequestMapping(value = "getPicBooksByCode/v1", method = RequestMethod.POST)
    ResponseParams<List<PictureBookDto>> getPicBooksByCode(@RequestBody GetPicBooksByCodeRequest req);

    /**
     * 判断书籍是否下架
     * @param request
     * @return
     */
    @RequestMapping(value = "v1/getBookShelvesFlag", method = RequestMethod.POST)
    ResponseParams<Boolean> getBookShelvesFlag(@RequestBody getBookShelvesFlagDto request);
}
