package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.GetAdUrlRequest;
import com.ella.resource.dto.SystemResourceNotify;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author:wangshuzheng
 * @date:2019/7/3 下午3:15
 * @des:开机视频服务接口
 */
@FeignClient("en-resource-service")
public interface OpSystemService {

    @RequestMapping(value = "/v1/opVideo/getVideo", method = RequestMethod.GET)
    ResponseParams getVideo();

    @RequestMapping(value = "/v1/opVideo/addVideo", method = RequestMethod.POST)
    ResponseParams addVideo(@RequestParam("filePath") String filePath);
    @RequestMapping(value = "/v1/opVideo/resGotNotify", method = RequestMethod.POST)
    ResponseParams resGotNotify(@RequestBody SystemResourceNotify systemResourceNotify);
    @RequestMapping(value = "/v1/opVideo/getAdUrl", method = RequestMethod.POST)
    ResponseParams getAdUrl(@RequestBody GetAdUrlRequest request);
}
