package com.ella.resource.api;


import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.ResponsePageResult;
import com.ella.resource.dto.UpdateStoneNumDto;
import com.ella.resource.dto.appdto.MapMissionDto;
import com.ella.resource.dto.missiondto.MissionDetailPageDto;
import com.ella.resource.dto.missiondto.MissionDto;
import com.ella.resource.dto.missiondto.MissionFullDto;
import com.ella.resource.dto.missiondto.MissionSetDto;
import com.ella.resource.dto.request.map.MapResourceDeleteRequest;
import com.ella.resource.dto.request.map.MapResourceSaveRequest;
import com.ella.resource.dto.request.mission.*;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 关卡服务
 *
 * @author Libin
 */
@FeignClient("en-resource-service")
public interface MissionService {
    /**
     * 关卡列表查询
     *
     * @param request request
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/mission/getMissionList", method = RequestMethod.POST)
    ResponseParams<MissionSetDto> getMissionList(@RequestBody GetMissionListRequest request);

    /**
     * 关卡详情查询
     *
     * @param request request
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/mission/getMissionInfo", method = RequestMethod.POST)
    ResponseParams<MissionDto> getMissionInfo(@RequestBody GetMissionInfoRequest request);

    /**
     * 关卡修改
     *
     * @param request request
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/mission/updateMission", method = RequestMethod.POST)
    ResponseParams<Boolean> updateMission(@RequestBody UpdateMissionRequest request);

    /**
     * 关卡移动
     *
     * @param request request
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/mission/moveMission", method = RequestMethod.POST)
    ResponseParams<Boolean> moveMission(@RequestBody MoveMissionRequest request);

    /**
     * 关卡新增
     *
     * @param request request
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/mission/saveMission", method = RequestMethod.POST)
    ResponseParams<Integer> saveMission(@RequestBody SaveMissionRequest request);

    /**
     * 关卡删除
     *
     * @param request request
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/mission/deleteMission", method = RequestMethod.POST)
    ResponseParams<Boolean> deleteMission(@RequestBody GetMissionInfoRequest request);

    /**
     * 新增地图的资源
     * Deprecated
     * @param request MapResourceSaveRequest
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/mission/saveMapResource", method = RequestMethod.POST)
    ResponseParams<Boolean> saveMapResource(@RequestBody MapResourceSaveRequest request);

    /**
     * 删除地图的资源
     * Deprecated
     * @param request MapResourceDeleteRequest
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/mission/deleteMapResource", method = RequestMethod.POST)
    ResponseParams<Boolean> deleteMapResource(@RequestBody MapResourceDeleteRequest request);

    /**
     * 关卡列表查询通过地图code
     *
     * @param mapCode mapCode
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/mission/getMissionListByMapCode", method = RequestMethod.POST)
    ResponseParams<List<MissionDto>> getMissionListByMapCode(@RequestParam("mapCode") String mapCode);

    /**
     * 删除地图的资源
     *
     * @param dto MissionSetDto
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/mission/updateMapResource", method = RequestMethod.POST)
    ResponseParams<Boolean> updateMapResource(@RequestBody MissionSetDto dto);

    /**
     * 查询关卡列表,返回关联等级地图信息（分页）
     */
    @RequestMapping(value = "/v1/mission/getMissionAndLevelList", method = RequestMethod.POST)
    ResponseParams<ResponsePageResult<List<MissionFullDto>>> getMissionAndLevelList(@RequestBody GetMissionLevelListRequest request);


    /**
     * 查询关卡列表,返回关联等级地图信息 (不分页)
     */
    @RequestMapping(value = "/v1/mission/getMissionAndLevelListNoPage", method = RequestMethod.POST)
    ResponseParams<List<MissionFullDto>> getMissionAndLevelListNoPage(@RequestBody GetMissionLevelListRequest request);

    /**
     * 获取阶段性测验/考试的详情页  ->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/mission/missionDetailPageInfo", method = RequestMethod.POST)
    ResponseParams<MissionDetailPageDto> missionDetailPageInfo(GetMissionDetailPageRequest request);

    @RequestMapping(value = "/v1/mission/getLevelCodeById", method = RequestMethod.GET)
    ResponseParams<MapMissionDto> getLevelCodeById(@RequestParam(value = "id", required = true) Long id);

    /**
     * @author wangshuzheng
     * @date 2019/8/15 下午6:05
     * @param updateStoneNumDto 能量石数更新对象
     * des 更新系统能量石数
    */
    @RequestMapping(value = "/v1/mission/updateStoneNum", method = RequestMethod.POST)
    ResponseParams<Boolean> updateStoneNum(@RequestBody UpdateStoneNumDto updateStoneNumDto);
}
