package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.MissionReportDto;
import com.ella.resource.dto.request.mission.GetMissionReportRequest;
import com.github.pagehelper.PageInfo;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient("en-resource-service")
public interface MissionReportService {

    /**
     * 获取关卡报表信息
     *
     * @param page
     * @return
     */
    @RequestMapping(value = "/v1/missionReport/getMissionReports", method = RequestMethod.POST)
    ResponseParams<PageInfo<MissionReportDto>> getMissionReports(GetMissionReportRequest page);

}
