package com.ella.resource.api;


import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.SendMissionStoneDto;
import com.ella.resource.dto.appdto.*;
import com.ella.resource.dto.request.app.*;
import com.ella.resource.dto.request.mission.GetMissionInfoRequest;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * 课程关卡服务
 *
 * @author Libin
 */
@FeignClient("en-resource-service")
public interface MissionCourseService {

    /**
     * 课后测试详情
     *
     * @param request GetMissionInfoRequest
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/missionCourse/courseTestInfo", method = RequestMethod.POST)
    ResponseParams<CourseTestInfoDto> courseTestInfo(@RequestBody GetMissionInfoRequest request);

    /**
     * 课堂资源下载完成
     *
     * @param request GetMissionInfoRequest
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/missionCourse/finishCourseDownload", method = RequestMethod.POST)
    ResponseParams<Boolean> finishCourseDownload(@RequestBody GetMissionInfoRequest request);

    /**
     * 课堂模式完成
     *
     * @param request GetMissionInfoRequest
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/missionCourse/finishCourseMode", method = RequestMethod.POST)
    ResponseParams<Boolean> finishCourseMode(@RequestBody GetMissionInfoRequest request);

    /**
     * 自学完成
     *
     * @param request GetMissionInfoRequest
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/missionCourse/finishSelfStudyMode", method = RequestMethod.POST)
    ResponseParams<Boolean> finishSelfStudyMode(@RequestBody GetMissionInfoRequest request);

    /**
     * 运营工具习题预览
     *
     * @param request GetMissionInfoRequest
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/missionCourse/testListPreview", method = RequestMethod.POST)
    ResponseParams<List<EnTestDto>> testListPreview(@RequestBody GetEnTestListRequest request);

    /**
     * 课后习题列表
     *
     * @param request GetMissionInfoRequest
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/missionCourse/getEnTestList", method = RequestMethod.POST)
    ResponseParams<List<EnTestDto>> getEnTestList(@RequestBody GetEnTestListRequest request);

    /**
     * 答题解析
     *
     * @param request TestAnswerRequest
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/missionCourse/analysisTest", method = RequestMethod.POST)
    ResponseParams<AnalysisTestDto> analysisTest(@RequestBody TestAnswerRequest request);

    /**
     * 答题记录
     *
     * @param request TestAnswerRequest
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/missionCourse/getLastTimeQuestionRecord", method = RequestMethod.POST)
    ResponseParams<TestRecordDto> getLastTimeQuestionRecord(@RequestBody GetEnTestListRequest request);

    /**
     * 课堂绘本资源下载完成
     *
     * @param request GetMissionInfoRequest
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/missionCourse/finishMissionPicDownload", method = RequestMethod.POST)
    ResponseParams<Boolean> finishMissionPicDownload(@RequestBody GetMissionInfoRequest request);

    /**
     * 课程关卡记录答题详情
     *
     * @param request {@link CourseAnswerPutRequest}
     * @return ResponseParams PutCourseAnswerDto
     */
    @RequestMapping(value = "/v1/missionCourse/putCourseAnswerInfo", method = RequestMethod.POST)
    ResponseParams<PutCourseAnswerDto> putCourseAnswerInfo(@RequestBody CourseAnswerPutRequest request);

    /**
     * 课程关卡获取答题记录
     *
     * @param request GetMissionInfoRequest
     * @return List<CourseAnswerInfoDto> {@link CourseAnswerInfoDto}
     */
    @RequestMapping(value = "/v1/missionCourse/getCourseAnswerInfo", method = RequestMethod.POST)
    ResponseParams<List<CourseAnswerInfoDto>> getCourseAnswerInfo(@RequestBody GetMissionInfoRequest request);

    /**
     * 课程关卡答题结果
     *
     * @param request AnalysisCourseAnswerRequest
     * @return AnalysisTestDto {@link AnalysisTestDto}
     */
    @RequestMapping(value = "/v1/missionCourse/analysisCourseAnswer", method = RequestMethod.POST)
    ResponseParams<AnalysisTestDto> analysisCourseAnswer(@RequestBody AnalysisCourseAnswerRequest request);

    /**
     * 闯关成功分享成绩
     *
     * @param request GetAnalysisTestRequest
     * @return SharePassResultDto {@link SharePassResultDto
     */
    @RequestMapping(value = "/v1/missionCourse/sharePassResult", method = RequestMethod.POST)
    ResponseParams<SharePassResultDto> sharePassResult(@RequestBody GetAnalysisTestRequest request);

    /**
     * 关卡资源更新赠送能量石
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/missionCourse/missionSendPower", method = RequestMethod.POST)
    ResponseParams<Boolean> missionSendPower(@RequestBody SendMissionStoneDto request);
}
