package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.MapAndOrderDto;
import com.ella.resource.dto.MapDto;
import com.ella.resource.dto.request.map.*;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 地图服务
 *
 * @author Libin
 */
@FeignClient("en-resource-service")
public interface MapService {

    /**
     * 获取地图列表
     *
     * @param request request
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/map/getMapList", method = RequestMethod.POST)
    ResponseParams<List<MapDto>> getMapList(@RequestBody GetMapListRequest request);

    /**
     * 获取地图详情
     *
     * @param request request
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/map/getMapInfo", method = RequestMethod.POST)
    ResponseParams<MapDto> getMapInfo(@RequestBody GetMapInfoRequest request);

    /**
     * 新增地图
     *
     * @param request request
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/map/saveMap", method = RequestMethod.POST)
    ResponseParams<Integer> saveMap(@RequestBody SaveMapRequest request);

    /**
     * 编辑地图
     *
     * @param request request
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/map/updateMap", method = RequestMethod.POST)
    ResponseParams<Boolean> updateMap(@RequestBody UpdateMapRequest request);

    /**
     * 删除地图
     *
     * @param request request
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/map/deleteMap", method = RequestMethod.POST)
    ResponseParams<Boolean> deleteMap(@RequestBody GetMapInfoRequest request);

    /**
     * 设置地图图标
     *
     * @param request request
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/map/setMapIco", method = RequestMethod.POST)
    ResponseParams<Boolean> setMapIco(@RequestBody SetMapIcoRequest request);

    /**
     * 设置地图底部图片
     *
     * @param request request
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/map/setMapBottomUrl", method = RequestMethod.POST)
    ResponseParams<Boolean> setMapBottomUrl(@RequestBody SetMapIcoRequest request);

    @RequestMapping(value = "/v1/map/getNextMapId", method = RequestMethod.POST)
    String getNextMapId(@RequestParam("uid") String uid, @RequestParam("mapCode") String mapCode);

    @RequestMapping(value = "/v1/map/selectMapAndOrder", method = RequestMethod.GET)
    ResponseParams<List<MapAndOrderDto>> selectMapAndOrder();
}
