package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.domain.LexileLevelHistory;
import com.ella.resource.dto.GetLevelInfoResponse;
import com.ella.resource.dto.LexileLevelHistoryDto;
import com.ella.resource.dto.StartLexileEvaluationRequest;
import com.ella.resource.dto.appdto.GetInitiativeInfoResponse;
import com.ella.resource.dto.request.lexile.LexileEvalutionHandOverRequest;
import com.ella.resource.dto.request.question.LexileAnswerRequest;
import com.ella.resource.dto.request.question.LexileAnswerResponse;
import com.ella.resource.dto.request.question.LexileEvaHistoryDetailDto;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@FeignClient("en-resource-service")
public interface LexileLevelHistoryService {

    @RequestMapping(value = "/v1/lexile-test/latest-history", method = RequestMethod.GET)
    ResponseParams<LexileLevelHistoryDto> latestLexileHistory(@RequestParam(value = "uid", required = true) String uid);

    @RequestMapping(value = "/v1/lexile-test/start", method = RequestMethod.POST)
    ResponseParams<LexileLevelHistoryDto> createLexileHistory(@RequestBody StartLexileEvaluationRequest request);

    /**
     * 蓝思评测交卷
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/lexile-test/handover", method = RequestMethod.POST)
    ResponseParams<LexileAnswerResponse> handover(@RequestBody LexileEvalutionHandOverRequest request);

    /**
     * 蓝思评测记录详情
     *
     * @param historyId 记录ID
     * @param uid       用户UID
     * @return
     */
    @RequestMapping(value = "/v1/lexile-test/history-detail", method = RequestMethod.POST)
    ResponseParams<LexileEvaHistoryDetailDto> historyDetail(
            @RequestParam(value = "historyId", required = true) Integer historyId,
            @RequestParam(value = "uid", required = true) String uid);


    @RequestMapping(value = "/v1/lexile-test/history-detail-by-levelcode", method = RequestMethod.GET)
    ResponseParams<LexileEvaHistoryDetailDto> maxScoreHistoryDetailByLevelCode(
            @RequestParam(value = "levelCode", required = true) String levelCode,
            @RequestParam(value = "uid", required = true) String uid);


    @RequestMapping(value = "/v1/lexile-test/history-detail-by-origin-levelcode", method = RequestMethod.GET)
    ResponseParams<LexileEvaHistoryDetailDto> maxScoreHistoryDetailByOriginLevelCode(
            @RequestParam(value = "levelCode", required = true) String levelCode,
            @RequestParam(value = "uid", required = true) String uid);


    @RequestMapping(value = "/v1/lexile-test/max-socre-history-by-Origin-levelcode", method = RequestMethod.GET)
    ResponseParams<LexileLevelHistoryDto> maxScoreHistoryByOriginLevelCode(
            @RequestParam(value = "levelCode", required = true) String levelCode,
            @RequestParam(value = "uid", required = true) String uid);

    @RequestMapping(value = "/v1/lexile-test/wrong-answer-missioninfo-by-history-id", method = RequestMethod.GET)
    ResponseParams<List<Map<String, Object>>> wrongAnswerMissonInfoByHistoryId(
            @RequestParam(value = "historyId", required = true) int historyId);

    @RequestMapping(value = "/v1/getInitiativeInfo", method = RequestMethod.GET)
    ResponseParams<GetInitiativeInfoResponse> getInitiativeInfo(@RequestParam("uid") String uid);

    @RequestMapping(value = "/v1/getLevelInfo", method = RequestMethod.GET)
    ResponseParams<GetLevelInfoResponse> getLevelInfo(@RequestParam("uid") String uid);

    /**
     * 获取用户蓝思评测历史评测记录信息
     * @param uid
     * @return
     */
    @RequestMapping(value = "/v1/getHistoryInfo", method = RequestMethod.GET)
    ResponseParams<LexileLevelHistory> getHistoryInfo(@RequestParam("uid") String uid);
}
