package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.config.FeignMultipartSupportConfig;
import com.ella.resource.dto.LexileEvaluationDto;
import com.ella.resource.dto.LexileEvaluationListDto;
import com.ella.resource.dto.LexileEvaluationPageDto;
import com.ella.resource.dto.LexileEvaluationQuestionDto;
import com.ella.resource.dto.request.lexile.*;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

@FeignClient(name = "en-resource-service", configuration = FeignMultipartSupportConfig.class)
public interface LexileEvaluationService {

    /**
     * 添加蓝思评测->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/LexileEvaluation/saveLexileEvaluation", method = RequestMethod.POST)
    ResponseParams<Boolean> saveLexileEvaluation(SaveLexileEvaluationRequest request);

    /**
     * 查询蓝思评测列表->zhaojl
     *
     * @return
     */
    @RequestMapping(value = "/v1/LexileEvaluation/getAllLexileInfo", method = RequestMethod.POST)
    ResponseParams<List<LexileEvaluationListDto>> getAllLexileInfo();

    @RequestMapping(value = "/v1/LexileEvaluation/saveLexiLeEvaluationDetail", method = RequestMethod.POST)
    ResponseParams<Boolean> saveLexiLeEvaluationDetail(LexileEvaluationQuestionRequest request);

    @RequestMapping(value = "/v1/LexileEvaluation/editLexiLeEvaluationDetail", method = RequestMethod.POST)
    ResponseParams<Boolean> editLexiLeEvaluationDetail(EditLexileEvaluationQuestionRequest request);

    @RequestMapping(value = "/v1/LexileEvaluation/deleteLexiLeEvaluationDetail", method = RequestMethod.POST)
    ResponseParams<Boolean> deleteLexiLeEvaluationDetail(DeleteLexileEvaluationQuestionRequest request);

    /**
     * 查询蓝思评测单个题目详情->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/LexileEvaluation/queryLexiLeEvaluationDetail", method = RequestMethod.POST)
    ResponseParams<LexileEvaluationQuestionDto> queryLexiLeEvaluationDetail(FindLexileQuestionItemRequest request);

    @RequestMapping(value = "/v1/LexileEvaluation/getQuestionDetail", method = RequestMethod.GET)
    ResponseParams<LexileEvaluationQuestionDto> getQuestionDetail(
            @RequestParam(value = "questionId", required = true) Long questionId);

    /**
     * 导入蓝思题目->zhaojl
     *
     * @param file
     * @param evaluationId
     * @return
     */
    @RequestMapping(value = "/v1/LexileEvaluation/importLexileEvaluation", method = RequestMethod.POST, produces = {
            MediaType.APPLICATION_JSON_UTF8_VALUE}, consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    ResponseParams<Boolean> importLexileEvaluation(@RequestPart(value = "file") MultipartFile file,
                                                   @RequestParam("evaluationId") String evaluationId);

    /**
     * 编辑蓝思题目属性值->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/LexileEvaluation/updateLexiLeEvaluationProperty", method = RequestMethod.POST)
    ResponseParams<Boolean> updateLexiLeEvaluationProperty(EditLexileEvaluationRequest request);

    /**
     * 获取某个蓝思评测的所有题目->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/LexileEvaluation/getOneLexileQuestions", method = RequestMethod.POST)
    ResponseParams<LexileEvaluationPageDto> getOneLexileQuestions(SelectOneLexileQuestionsRequest request);

    /**
     * 根据等级编号查询对应的蓝思评测
     *
     * @param levelCode
     * @return
     */
    @RequestMapping(value = "/v1/LexileEvaluation/getByLevelCode", method = RequestMethod.GET)
    ResponseParams<LexileEvaluationDto> getEvaluationByLevelCode(
            @RequestParam(value = "levelCode", required = true) String levelCode);

    /**
     * 根据考试ID查询对应的蓝思评测
     *
     * @param id id
     * @return
     */
    @RequestMapping(value = "/v1/LexileEvaluation/getById", method = RequestMethod.GET)
    ResponseParams<LexileEvaluationDto> getEvaluationById(@RequestParam(value = "id", required = true) Long id);

    /**
     * 根据等级编号查询对应的蓝思评测(包含题目详情)
     *
     * @param levelCode
     * @return
     */
    @RequestMapping(value = "/v1/LexileEvaluation/getDetailByLevelCode", method = RequestMethod.GET)
    ResponseParams<LexileEvaluationDto> getEvaluationDetailByLevelCode(
            @RequestParam(value = "levelCode", required = true) String levelCode);

    /**
     * 根据ID查询包含题目详情的蓝思评测
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/v1/LexileEvaluation/getEvaluationDetailById", method = RequestMethod.GET)
    ResponseParams<LexileEvaluationDto> getEvaluationDetailById(@RequestParam(value = "id", required = true) Long id);

    /**
     * 统计蓝思评测对应的题目数量
     *
     * @param evaluationId
     * @return
     */
    @RequestMapping(value = "/v1/LexileEvaluation/countQuestion", method = RequestMethod.GET)
    ResponseParams<Integer> countEvaluationQuestiones(
            @RequestParam(value = "evaluationId", required = true) Long evaluationId);

    /**
     * 修改蓝思评测等级对应信息
     *
     * @param req req
     * @return
     */
    @RequestMapping(value = "/v1/LexileEvaluation/modifyLexileEvaluationInf", method = RequestMethod.POST)
    ResponseParams<Boolean> modifyLexileEvaluationInf(@RequestBody ModifyLexileEvaluationInfRequest req);
}
