package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.LevelDto;
import com.ella.resource.dto.LevelListDto;
import com.ella.resource.dto.request.GetLevelInfoRequest;
import com.ella.resource.dto.request.UpdateLevelRequest;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 等级服务
 *
 * @author LiBin
 **/
@FeignClient("en-resource-service")
public interface LevelService {

    /**
     * 获取等级列表
     *
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/level/getLevelList", method = RequestMethod.GET)
    ResponseParams<List<LevelListDto>> getLevelList();

    /**
     * 获取等级详情
     *
     * @param request request
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/level/getLevelInfo", method = RequestMethod.POST)
    ResponseParams<LevelDto> getLevelInfo(@RequestBody GetLevelInfoRequest request);

    /**
     * 修改等级信息
     *
     * @param request request
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/level/updateLevel", method = RequestMethod.POST)
    ResponseParams<Boolean> updateLevel(@RequestBody UpdateLevelRequest request);

    /**
     * 等级确认
     *
     * @param request request
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/level/doSureLevel", method = RequestMethod.POST)
    ResponseParams<Boolean> doSureLevel(GetLevelInfoRequest request);

    /**
     * 查询所有可用等级列表
     * <p>
     * 查询已确认的所有等级列表，包含等级详情，用于前端等级信息介绍
     * </p>
     *
     * @return 等级详情信息列表
     */
    @RequestMapping(value = "/v1/level/all-enable-levels", method = RequestMethod.GET)
    ResponseParams<List<LevelDto>> allEnableLevels();

    /**
     * 获取默认等级，即最初等级
     *
     * @return
     */
    @RequestMapping(value = "/v1/level/default", method = RequestMethod.GET)
    ResponseParams<LevelDto> defaultLevel();

    /**
     * 根据code查询等级信息
     *
     * @return
     */
    @RequestMapping(value = "/v1/level/get-by-code", method = RequestMethod.GET)
    ResponseParams<LevelDto> getLevelByCode(@RequestParam(value = "code", required = true) String code);

    /**
     * 根据等级序号查询等级信息
     *
     * @param levelIndex
     * @return
     */
    @RequestMapping(value = "/v1/level/get-by-index", method = RequestMethod.GET)
    ResponseParams<LevelDto> getLevelByIndex(@RequestParam(value = "levelIndex", required = true) Integer levelIndex);

    /**
     * 根据等级code获取levelDto
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/level/getLevelByCode", method = RequestMethod.POST)
    ResponseParams<LevelDto> getLevelByCode(GetLevelInfoRequest request);

    /**
     * 根据等级蓝思能力值获取levelDto
     *
     * @param ability
     * @return
     */
    @RequestMapping(value = "/v1/level/get-by-ability", method = RequestMethod.GET)
    ResponseParams<LevelDto> getLevelByAbility(@RequestParam(value = "ability", required = true) Integer ability);

    /**
     * 获取蓝思指数类别code 列表
     * @return
     */
    @RequestMapping(value = "/v1/level/getLexileResTypeCodeList", method = RequestMethod.GET)
    ResponseParams<List<String>> getLexileResTypeCodeList();

    @RequestMapping(value = "/v1/level/transferLexileLevel", method = RequestMethod.POST)
    String transferLexileLevel(@RequestParam("lexileLevel") String lexileLevel);
}
