package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.IraMapDto;
import com.ella.resource.dto.IraReportDto;
import com.ella.resource.dto.MapDto;
import com.ella.resource.dto.request.ira.GetIraReportRequest;
import com.ella.resource.dto.request.ira.ReadRecordIraRequest;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author liyuanyuan
 * @dscription 描述
 * @date 2019/11/15 16:22
 */
@FeignClient("en-resource-service")
public interface IraReportService {

    /**
     * 获取IRA报告
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/iraReport/getIraReport", method = RequestMethod.POST)
    ResponseParams<IraReportDto> getIraReport(GetIraReportRequest request);


    /**
     * 记录用户进出阅读器时长
     *
     * @param readRecordIraRequest
     * @return
     */
    @RequestMapping(value = "/v1/iraReport/readRecordIra", method = RequestMethod.POST)
    ResponseParams<Boolean> insertReadRecordIra(ReadRecordIraRequest readRecordIraRequest);

    /**
     * 获取用户ira阅读报告更新状态
     * @param cid
     * @return
     */
    @RequestMapping(value = "/v1/iraReport/getIraReportUpdateStatus", method = RequestMethod.POST)
    ResponseParams<List<IraMapDto>> getIraReportUpdateStatus(@RequestParam("cid") String cid);
}
