package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.appdto.HomePageDto;
import com.ella.resource.dto.appdto.LevelPopupDto;
import com.ella.resource.dto.appdto.PicBookPopupDto;
import com.ella.resource.dto.request.BaseRequest;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 用户首页服务
 *
 * @author Libin
 */
@FeignClient("en-resource-service")
public interface HomePageService {
    /**
     * 获取等级弹窗数据
     *
     * @param uid uid
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/homePage/levelPopup", method = RequestMethod.POST)
    ResponseParams<LevelPopupDto> levelPopup(@RequestParam(value = "uid", required = false) String uid, @RequestParam("levelCode") String levelCode);

    /**
     * 用户首页
     *
     * @param request request
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/homePage/userHomePage", method = RequestMethod.POST)
    ResponseParams<HomePageDto> userHomePage(@RequestBody BaseRequest request);

    /**
     * 绘本弹窗
     *
     * @param uid uid
     * @return Integer
     */
    @RequestMapping(value = "/v1/homePage/picBookPopup", method = RequestMethod.POST)
    ResponseParams<PicBookPopupDto> picBookPopup(@RequestParam("uid") String uid);
}
