package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author
 * @date 2019/11/15 16:22
 */
@FeignClient("boeen-resource-service")
public interface GenerateOneIraReportService {
    /**
     * 生成一个人的IRA
     * @param cid
     * @return
     */
    @RequestMapping(value = "/v1/iraReport/generateOneReport", method = RequestMethod.POST)
    ResponseParams<Boolean> generateOneReport(@RequestParam("cid") String cid);

    /**
     * 生成IRA
     * @return
     */
    @RequestMapping(value = "/v1/iraReport/generateAllIraReport", method = RequestMethod.POST)
    ResponseParams<Boolean> generateAllIraReport();
}
