package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.ellacoin.CoinConfigDto;
import com.ella.resource.dto.ellacoin.GetEllaCoinListByConditRequest;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 咿啦币配置表
 *
 * @author Libin
 */
@FeignClient("en-resource-service")
public interface EllaCoinConfigService {

    /**
     * 查询咿啦币配置列表
     *
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/ellaCoinConfig/getEllaCoinConfigList", method = RequestMethod.POST)
    ResponseParams<List<CoinConfigDto>> getEllaCoinConfigList(@RequestParam(value = "type") String type);

    /**
     * 根据列表查询咿啦币配置列表
     *
     * @param req req
     * @return ResponseParams
     */
    @RequestMapping(value = "/v1/ellaCoinConfig/getEllaCoinConfigListByCondit", method = RequestMethod.POST)
    ResponseParams<List<CoinConfigDto>> getEllaCoinConfigListByCondit(@RequestBody GetEllaCoinListByConditRequest req);

    /**
     * 根据商品表itemCode 获取会员和蓝思评测配置列表
     * @param itemCodeStr
     * @return
     */
    @RequestMapping(value = "/v1/ellaCoinConfig/getVipCardConfigByItemCode", method = RequestMethod.POST)
    ResponseParams<List<CoinConfigDto>> getVipCardConfigByItemCode(@RequestParam(value = "itemCodeStr")  String itemCodeStr);


}
