package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.CourseListDto;
import com.ella.resource.dto.request.*;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author ZLN
 * @create 2018-07-28 14:07
 **/
@FeignClient("en-resource-service")
public interface CourseService {
    /**
     * 课程/绘本动画书添加
     *
     * @param res
     * @return
     */
    @RequestMapping(value = "selectBookList/v1", method = RequestMethod.POST)
    ResponseParams selectBookList(@RequestBody BaseBookListRes res);

    /**
     * 课程获取详情页
     *
     * @param req
     * @return
     */
    @RequestMapping(value = "getCourseInfo/v1", method = RequestMethod.POST)
    ResponseParams getCourseInfo(@RequestBody GetCourseInfoReq req);

    /**
     * 添加视频接口
     *
     * @param req
     * @return
     */
    @RequestMapping(value = "addCourseVedio/v1", method = RequestMethod.POST)
    ResponseParams addCourseVedio(@RequestBody CourseVedioReq req);

    /**
     * 课程列表接口--分页
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "v1/courseList", method = RequestMethod.POST)
    ResponseParams courseList(@RequestBody CourseRequest request);

    /**
     * 新增课程
     *
     * @param dto
     * @return
     */
    @RequestMapping(value = "v1/addCourse", method = RequestMethod.POST)
    ResponseParams addCourse(@RequestBody CourseListDto dto);

    @RequestMapping(value = "v1/updateCourse", method = RequestMethod.POST)
    ResponseParams updateCourse(@RequestBody CourseListDto dto);

    /**
     * 课程添加题目
     *
     * @param res
     * @return
     */
    @RequestMapping(value = "v1/addCourseQestion", method = RequestMethod.POST)
    ResponseParams addCourseQestion(@RequestBody AddCourseQestionRes res);

    /**
     * 课程习题修改位置
     *
     * @param res
     * @return
     */
    @RequestMapping(value = "v1/changeCourseQuestionIndex", method = RequestMethod.POST)
    ResponseParams changeCourseQuestionIndex(@RequestBody ChangeCourseQuestionIndexRes res);

    /**
     * 课程题目列表
     *
     * @param res
     * @return
     */
    @RequestMapping(value = "v1/courseQuestionList", method = RequestMethod.POST)
    ResponseParams courseQuestionList(@RequestBody CourseQuestionListReq res);

    /**
     * 课程题目列表删除题目
     *
     * @param res
     * @return
     */
    @RequestMapping(value = "v1/courseQuestionDel", method = RequestMethod.POST)
    ResponseParams courseQuestionDel(@RequestBody CourseQuestionListReq res);
}
