package com.ella.resource.api;

import com.ella.frame.common.response.ResponseParams;
import com.ella.resource.dto.ActivitySendGoodsDto;
import com.ella.resource.dto.PageDto;
import com.ella.resource.dto.request.activity.EditActivitySendGoodsRequest;
import com.ella.resource.dto.request.activity.FindActivityRequest;
import com.ella.resource.dto.request.activity.SaveActivitySendGoodsRequest;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient("en-resource-service")
public interface ActivityService {

    /**
     * 添加活动->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/activity/saveActivitySendGoods", method = RequestMethod.POST)
    ResponseParams<Boolean> saveActivitySendGoods(SaveActivitySendGoodsRequest request);

    /**
     * 编辑活动->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/activity/udpateActivitySendGoods", method = RequestMethod.POST)
    ResponseParams<Boolean> udpateActivitySendGoods(EditActivitySendGoodsRequest request);

    /**
     * 获取指定活动信息->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/activity/selectActivityById", method = RequestMethod.POST)
    ResponseParams<ActivitySendGoodsDto> selectActivityById(FindActivityRequest request);

    /**
     * 查询活动列表->zhaojl
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/v1/activity/selectAllActivity", method = RequestMethod.POST)
    ResponseParams<?> selectAllActivity(PageDto request);
}
