/*
 * Decompiled with CFR 0.152.
 */
package com.ella.frame.common.util;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DateUtil {
    public static String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static String DEFAULT_BEGIN_TIME = " 00:00:00";
    public static String DEFAULT_END_TIME = " 23:59:59";

    public static String dateToString(Date date, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    public static String dateToString(Date date) {
        return DateUtil.dateToString(date, DEFAULT_FORMAT);
    }

    public static Date stringToDate(String date, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        try {
            return df.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date stringToDate(String date) {
        return DateUtil.stringToDate(date, DEFAULT_FORMAT);
    }

    public static Integer leftTime(Date date) {
        Long beginTimes = DateUtil.dateConvert(new Date(), DEFAULT_BEGIN_TIME);
        Long endTimes = DateUtil.dateConvert(date, DEFAULT_END_TIME);
        Long leftTime = (endTimes - beginTimes) / 1000L / 60L / 60L;
        leftTime = leftTime % 24L == 0L ? Long.valueOf(leftTime / 24L) : Long.valueOf(leftTime / 24L + 1L);
        return Integer.valueOf(String.valueOf(leftTime));
    }

    public static Long dateConvert(Date date, String endTime) {
        String dateStr = DateUtil.dateToString(date, DEFAULT_DATE_FORMAT) + endTime;
        Date nowDate = DateUtil.stringToDate(dateStr);
        System.out.println(dateStr);
        System.out.println(nowDate.getTime());
        return nowDate.getTime();
    }

    public static Date todayLastTime() {
        SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_FORMAT);
        LocalDate today = LocalDate.now();
        Date dat = new Date();
        String dateStr = today + DEFAULT_END_TIME;
        Date nowDate = null;
        try {
            nowDate = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return nowDate;
    }

    public static int getIntervalDay(Date tar) {
        int ret = -1;
        Calendar calNow = Calendar.getInstance();
        if (null != tar && tar.before(calNow.getTime())) {
            Calendar calTar = Calendar.getInstance();
            calTar.setTime(tar);
            long millisNow = calNow.getTimeInMillis();
            long millisTar = tar.getTime();
            if (millisTar < millisNow) {
                ret = (int)((millisNow - millisTar) / 86400000L);
            }
        }
        return ret;
    }

    public static String getLastMonth() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        return format.format(calendar.getTime());
    }

    public static String getLastMonth(String month) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(format.parse(month));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        calendar.add(2, -1);
        return format.format(calendar.getTime());
    }

    public static Date getLastDay(Date data) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(data);
        calendar.add(6, -1);
        return calendar.getTime();
    }

    public static String getTodayDateStr() {
        SimpleDateFormat format = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        return format.format(new Date());
    }

    public static String getNextDay(String day, int n) {
        SimpleDateFormat sdf = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(sdf.parse(day));
            calendar.add(5, n);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String tomorrow = sdf.format(calendar.getTime());
        return tomorrow;
    }

    public static Date[] getFirstAndLastOfWeek(Date data) {
        Date[] dates = new Date[2];
        Calendar cal = Calendar.getInstance();
        cal.setTime(data);
        int d = 0;
        d = cal.get(7) == 1 ? -6 : 2 - cal.get(7);
        cal.add(7, d);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        SimpleDateFormat sdf2 = new SimpleDateFormat(DEFAULT_FORMAT);
        String dateS = sdf.format(cal.getTime());
        try {
            dates[0] = sdf.parse(dateS);
            cal.add(7, 6);
            dateS = sdf1.format(cal.getTime());
            dates[1] = sdf2.parse(dateS);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return dates;
    }

    public static Date getLastdayOfMonth(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        SimpleDateFormat sdf1 = new SimpleDateFormat(DEFAULT_FORMAT);
        Calendar ca = Calendar.getInstance();
        try {
            ca.setTime(date);
            ca.set(5, 1);
            ca.add(2, 1);
            ca.add(5, -1);
            String dateS = sdf.format(ca.getTime());
            return sdf1.parse(dateS);
        }
        catch (ParseException e) {
            return ca.getTime();
        }
    }

    public static Date getFirstdayOfMonth(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.set(5, 1);
        try {
            String dateS = sdf.format(ca.getTime());
            return sdf.parse(dateS);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return ca.getTime();
        }
    }

    public static Date getFirstdayOfNextMonth(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.set(5, 1);
        ca.add(2, 1);
        try {
            String dateS = sdf.format(ca.getTime());
            return sdf.parse(dateS);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return ca.getTime();
        }
    }

    public static long daysBetweenNew(Date before, Date after) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(before);
        long time1 = cal.getTimeInMillis();
        cal.setTime(after);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Math.abs(between_days);
    }

    public static boolean isSameDay(Date date1, Date date2) {
        String dateString2;
        String dateString1 = DateUtil.dateToString(date1, "yyyy-MM-dd");
        return StringUtils.equalsIgnoreCase((CharSequence)dateString1, (CharSequence)(dateString2 = DateUtil.dateToString(date2, "yyyy-MM-dd")));
    }

    public static Date plusDay(int num, Date newDate) {
        try {
            Calendar ca = Calendar.getInstance();
            ca.setTime(newDate);
            ca.add(5, num);
            newDate = ca.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            return newDate;
        }
        return newDate;
    }

    public static List<Date> getPreAndCurrentZeroOClock(Date date) {
        ArrayList dateResult = Lists.newArrayList((Object[])new Date[]{null, null});
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        dateResult.set(1, calendar.getTime());
        calendar.add(6, -1);
        dateResult.set(0, calendar.getTime());
        return dateResult;
    }

    public static boolean isEffectiveDate(Date nowTime, Date startTime, Date endTime) {
        if (nowTime.getTime() == startTime.getTime() || nowTime.getTime() == endTime.getTime()) {
            return true;
        }
        Calendar date = Calendar.getInstance();
        date.setTime(nowTime);
        Calendar begin = Calendar.getInstance();
        begin.setTime(startTime);
        Calendar end = Calendar.getInstance();
        end.setTime(endTime);
        return date.after(begin) && date.before(end);
    }

    public static boolean isDiffMonth(String date1, String date2) {
        return DateUtil.isDiffMonth(DateUtil.stringToDate(date1, DEFAULT_DATE_FORMAT), DateUtil.stringToDate(date2, DEFAULT_DATE_FORMAT));
    }

    public static boolean isDiffMonth(Date date1, Date date2) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        return calendar1.get(1) == calendar2.get(1) && calendar1.get(2) == calendar2.get(2);
    }

    public static Integer getDifMonth(String startDate, String endDate) {
        return DateUtil.getDifMonth(DateUtil.stringToDate(startDate, DEFAULT_DATE_FORMAT), DateUtil.stringToDate(endDate, DEFAULT_DATE_FORMAT));
    }

    public static Integer getDifMonth(Date startDate, Date endDate) {
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        start.setTime(startDate);
        end.setTime(endDate);
        int result = end.get(2) - start.get(2);
        int month = (end.get(1) - start.get(1)) * 12;
        return Math.abs(month + result);
    }

    public static String dateFormatOfMMdd(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("MM\u6708dd\u65e5");
        return format.format(date);
    }

    public static int differentDays(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        int year2 = cal2.get(1);
        if (year1 != year2) {
            int timeDistance = 0;
            for (int i = year1; i < year2; ++i) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    timeDistance += 366;
                    continue;
                }
                timeDistance += 365;
            }
            return timeDistance + (day2 - day1);
        }
        System.out.println("\u5224\u65adday2 - day1 : " + (day2 - day1));
        return day2 - day1;
    }
}

