/*
 * Decompiled with CFR 0.152.
 */
package com.ella.frame.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombineBeansUtil {
    private static final Logger log = LoggerFactory.getLogger(CombineBeansUtil.class);

    public static <T> T combineBeans(T sourceBean, T targetBean) {
        Class<?> sourceBeanClass = sourceBean.getClass();
        Class<?> targetBeanClass = targetBean.getClass();
        Field[] sourceFields = sourceBeanClass.getDeclaredFields();
        Field[] targetFields = sourceBeanClass.getDeclaredFields();
        for (int i = 0; i < sourceFields.length; ++i) {
            Field sourceField = sourceFields[i];
            Field targetField = targetFields[i];
            sourceField.setAccessible(true);
            targetField.setAccessible(true);
            try {
                if (sourceField.get(sourceBean) == null) continue;
                targetField.set(targetBean, sourceField.get(sourceBean));
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return targetBean;
    }

    public static <T1, T2> T2 copyBeans(T1 sourceBean, T2 targetBean) {
        List<Map<String, Object>> modelList = CombineBeansUtil.getFiledInfo(sourceBean);
        List<Map<String, Object>> entityList = CombineBeansUtil.getFiledInfo(targetBean);
        for (Map<String, Object> e : entityList) {
            for (Map<String, Object> m : modelList) {
                if (!e.get("type").toString().equals(m.get("type").toString()) || !e.get("name").toString().equals(m.get("name").toString())) continue;
                try {
                    Field f = targetBean.getClass().getDeclaredField(e.get("name").toString());
                    f.setAccessible(true);
                    f.set(targetBean, m.get("value"));
                }
                catch (Exception ex) {
                    try {
                        Field f = targetBean.getClass().getSuperclass().getDeclaredField(e.get("name").toString());
                        f.setAccessible(true);
                        f.set(targetBean, m.get("value"));
                    }
                    catch (Exception e1) {
                        log.error(ex.getMessage(), (Object)("conversion\u7c7b\u578b\u8f6c\u6362\u9519\u8bef " + ex));
                    }
                }
            }
        }
        return targetBean;
    }

    private static List<Map<String, Object>> getFiledInfo(Object o) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(o.getClass().getDeclaredFields()));
        Class<?> sc = o.getClass().getSuperclass();
        if (sc != null) {
            fields.addAll(Arrays.asList(sc.getDeclaredFields()));
        }
        for (Field field : fields) {
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            infoMap.put("type", field.getType().toString());
            infoMap.put("name", field.getName());
            infoMap.put("value", CombineBeansUtil.getFieldValueByName(field.getName(), o));
            list.add(infoMap);
        }
        return list;
    }

    private static Object getFieldValueByName(String fieldName, Object o) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = o.getClass().getMethod(getter, new Class[0]);
            Object value = method.invoke(o, new Object[0]);
            return value;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static String[] getFiledName(Object o) {
        Field[] fields = o.getClass().getDeclaredFields();
        String[] fieldNames = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldNames[i] = fields[i].getName();
        }
        return fieldNames;
    }
}

