/*
 * Decompiled with CFR 0.152.
 */
package com.ella.frame.common.response;

import com.ella.frame.common.errorcode.CommonRetCode;
import java.io.Serializable;

public class ResponseParams<T>
implements Serializable {
    private static final long serialVersionUID = 9201704575681258823L;
    public static String STATUS_SUCCEED = "1";
    public static String STATUS_FAILURE = "0";
    private String code;
    private String status;
    private String message;
    private String remark = "";
    private T data;

    public ResponseParams setCode(String code) {
        this.code = code;
        return this;
    }

    public ResponseParams setMsg(String msg) {
        this.message = msg;
        return this;
    }

    public ResponseParams setData(T data) {
        this.data = data;
        return this;
    }

    public ResponseParams(CommonRetCode success) {
        this.code = success.getCode();
        this.message = success.getMsg();
    }

    public ResponseParams(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public ResponseParams() {
    }

    public ResponseParams(String code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public ResponseParams(String code, String message, String description, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static <S> ResponseParams<S> buildSuccessResponse() {
        return ResponseParams.build(CommonRetCode.SUCCESS);
    }

    public static <S> ResponseParams<S> buildSuccessResponse(S data) {
        return ResponseParams.build(CommonRetCode.SUCCESS, data);
    }

    public static <S> ResponseParams<S> build(CommonRetCode crc) {
        return ResponseParams.build(crc.getCode(), crc.getMsg());
    }

    public static <S> ResponseParams<S> build(CommonRetCode crc, S data) {
        return ResponseParams.build(crc.getCode(), crc.getMsg(), data);
    }

    public static <S> ResponseParams<S> build(String code, String message) {
        return ResponseParams.build(code, message, null);
    }

    public static <S> ResponseParams<S> build(String code, S data) {
        return ResponseParams.build(code, null, data);
    }

    public static <S> ResponseParams<S> build(String code, String message, S data) {
        return ResponseParams.build(code, message, null, data);
    }

    public static <S> ResponseParams<S> build(String code, String message, String description, S data) {
        return new ResponseParams<S>(code, message, description, data);
    }

    public static <S> ResponseParams<S> build(CommonRetCode dataNotExisted, String code) {
        return new ResponseParams<Object>(code, null, null, null);
    }

    public static <S> ResponseParams<S> buildFailResponse(String code, String message, String description, S data) {
        return new ResponseParams<S>(code, message, description, data);
    }

    public static <S> ResponseParams<S> buildFailResponse(String code, String message, String description) {
        return new ResponseParams<Object>(code, message, description, null);
    }

    public static <S> ResponseParams<S> buildFailResponse(String code, String message, S data) {
        return new ResponseParams<S>(code, message, null, data);
    }

    public static <S> ResponseParams<S> buildFailResponse(String code, String message) {
        return new ResponseParams<Object>(code, message, null, null);
    }

    public static <S> ResponseParams<S> buildFailResponse(String code, S data) {
        return new ResponseParams<S>(code, null, null, data);
    }

    public static <S> ResponseParams<S> buildFailResponse(String code) {
        return new ResponseParams<Object>(code, null, null, null);
    }

    public String getCode() {
        return this.code;
    }

    public String getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public String getRemark() {
        return this.remark;
    }

    public T getData() {
        return this.data;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResponseParams)) {
            return false;
        }
        ResponseParams other = (ResponseParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResponseParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ResponseParams(code=" + this.getCode() + ", status=" + this.getStatus() + ", message=" + this.getMessage() + ", remark=" + this.getRemark() + ", data=" + this.getData() + ")";
    }
}

