/*
 * Decompiled with CFR 0.152.
 */
package com.ella.frame.common.errorcode;

import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import java.io.Serializable;

public class ErrorMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String code;
    private Object data;
    private String message;
    private String remark = "";
    private String status;

    public static final ErrorMessage valueOf(CommonRetCode errorCode) {
        return new ErrorMessage(errorCode.getCode(), errorCode.getMsg(), errorCode.getDescription());
    }

    public ErrorMessage(String code, String error, Object descrpition) {
        this.code = code;
        if (CommonRetCode.SUCCESS.getCode().equals(code)) {
            this.data = descrpition;
        }
        this.status = ResponseParams.STATUS_FAILURE;
        this.message = error;
    }

    public ErrorMessage(String code, String msg) {
        this.code = code;
        this.message = msg;
        this.status = ResponseParams.STATUS_FAILURE;
    }

    public String getCode() {
        return this.code;
    }

    public Object getData() {
        return this.data;
    }

    public String getMessage() {
        return this.message;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getStatus() {
        return this.status;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorMessage)) {
            return false;
        }
        ErrorMessage other = (ErrorMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        Object this$data = this.getData();
        Object other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ErrorMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        Object $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    public String toString() {
        return "ErrorMessage(code=" + this.getCode() + ", data=" + this.getData() + ", message=" + this.getMessage() + ", remark=" + this.getRemark() + ", status=" + this.getStatus() + ")";
    }
}

