/*
 * Decompiled with CFR 0.152.
 */
package com.ella.common.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpUtils {
    private static final Logger log = LogManager.getLogger(HttpUtils.class);

    public static String doGet(String url) {
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpGet request = new HttpGet(url);
            HttpResponse response = client.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 200) {
                String strResult = EntityUtils.toString((HttpEntity)response.getEntity());
                return strResult;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String doPost(String url, Map params) {
        Object in = null;
        try {
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpPost request = new HttpPost();
            request.setURI(new URI(url));
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            for (Object o : params.keySet()) {
                String name = (String)o;
                String value = String.valueOf(params.get(name));
                nvps.add(new BasicNameValuePair(name, value));
            }
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8));
            HttpResponse response = client.execute((HttpUriRequest)request);
            int code = response.getStatusLine().getStatusCode();
            if (code == 200) {
                return EntityUtils.toString((HttpEntity)response.getEntity());
            }
            System.out.println("\u72b6\u6001\u7801\uff1a" + code);
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, String params) throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-Type", "application/json");
        String charSet = "UTF-8";
        StringEntity entity = new StringEntity(params, charSet);
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpPost);
            StatusLine status = response.getStatusLine();
            int state = status.getStatusCode();
            if (state == 200) {
                String jsonString;
                HttpEntity responseEntity = response.getEntity();
                String string = jsonString = EntityUtils.toString((HttpEntity)responseEntity);
                return string;
            }
            log.error("\u8bf7\u6c42\u8fd4\u56de:" + state + "(" + url + ")");
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpMultipartRequest(String url, InputStream inputStream, String fileParName, Map<String, Object> params, int timeout) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        String result = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setCharset(Charset.forName("UTF-8"));
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.addBinaryBody(fileParName, inputStream, ContentType.MULTIPART_FORM_DATA, "8748857967181824.mp3");
            ContentType contentType = ContentType.create((String)"text/plain", (Charset)Charset.forName("UTF-8"));
            if (params != null) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    if (entry.getValue() == null) continue;
                    builder.addTextBody(entry.getKey(), entry.getValue().toString(), contentType);
                }
            }
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            httpPost.setHeader("Request-Index", "0");
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
            httpPost.setConfig(requestConfig);
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                String string = result = EntityUtils.toString((HttpEntity)responseEntity, (Charset)Charset.forName("UTF-8"));
                return string;
            }
        }
        catch (Exception e) {
            log.error("HTTP\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38: ", (Throwable)e);
            result = "HTTP\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38";
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

