/*
 * Decompiled with CFR 0.152.
 */
package com.ella.common.service;

import com.ella.common.api.VersionService;
import com.ella.common.domain.UserPopRecod;
import com.ella.common.domain.UserPopRecodExample;
import com.ella.common.domain.Version;
import com.ella.common.domain.VersionExample;
import com.ella.common.dto.AddVersionReq;
import com.ella.common.dto.GetUpdataReq;
import com.ella.common.dto.GetVersionListReq;
import com.ella.common.dto.RetCodeEnum;
import com.ella.common.mapper.UserPopRecodMapper;
import com.ella.common.mapper.VersionMapper;
import com.ella.common.utils.Putil;
import com.ella.common.utils.ResponseBuildUtil;
import com.ella.frame.aop.annotion.EnableValidate;
import com.ella.frame.common.errorcode.CommonRetCode;
import com.ella.frame.common.response.ResponseParams;
import com.ella.frame.common.util.CoreUtil;
import com.github.pagehelper.PageHelper;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class VersionServiceImpl
implements VersionService {
    private static final Logger log = LogManager.getLogger(VersionServiceImpl.class);
    @Autowired
    private VersionMapper versionMapper;
    @Autowired
    private UserPopRecodMapper userPopRecodMapper;

    @EnableValidate
    public ResponseParams getUpdata(@RequestBody GetUpdataReq req) throws Exception {
        VersionExample versionExample = new VersionExample();
        versionExample.setOrderByClause("id desc");
        versionExample.createCriteria().andStatusEqualTo("NORMAL").andVersionStartTimeLessThanOrEqualTo(new Date()).andVersionResourceEqualTo(req.getVersionResource());
        PageHelper.startPage((int)1, (int)1);
        List versions = this.versionMapper.selectByExample(versionExample);
        if (!CollectionUtils.isEmpty((Collection)versions)) {
            Version version = (Version)versions.get(0);
            String adviceRange = version.getAdviceRange();
            String[] split = adviceRange.split("-");
            int min = CoreUtil.compareVersion((String)req.getVersionNum(), (String)split[0]);
            int max = CoreUtil.compareVersion((String)req.getVersionNum(), (String)split[1]);
            if (!(min > 0 && max < 0 || String.valueOf(split[0]).equals(req.getVersionNum()) || String.valueOf(split[1]).equals(req.getVersionNum()))) {
                return ResponseBuildUtil.build((CommonRetCode)CommonRetCode.SUCCESS, null);
            }
            if ("EVERY_TIME".equals(version.getAdviceRate())) {
                return ResponseBuildUtil.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)version);
            }
            if ("DAILY_PUSH".equals(version.getAdviceRate()) && version.getForceUpdate() == 0) {
                UserPopRecodExample userPopRecodExample = new UserPopRecodExample();
                List todayData = this.getTodayData();
                userPopRecodExample.createCriteria().andItemIdEqualTo(version.getId()).andItemTypeEqualTo("VERSION").andCreateTimeBetween((Date)todayData.get(0), (Date)todayData.get(1)).andUidEqualTo(req.getUid());
                List userPopRecods = this.userPopRecodMapper.selectByExample(userPopRecodExample);
                if (!CollectionUtils.isEmpty((Collection)userPopRecods)) {
                    return ResponseBuildUtil.build((RetCodeEnum)RetCodeEnum.NO_UPDATE_AVAILABLE);
                }
                this.insertuserPopRecod(version, req.getUid());
                return ResponseBuildUtil.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)version);
            }
        }
        return ResponseBuildUtil.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)versions);
    }

    @EnableValidate
    public ResponseParams addOrUpdateVersion(@RequestBody AddVersionReq req) {
        Version version = new Version();
        version.setStatus("NORMAL");
        BeanUtils.copyProperties((Object)req, (Object)version);
        int count = this.versionMapper.updateByPrimaryKey(version);
        if (count == 1) {
            return ResponseBuildUtil.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)count);
        }
        int i = this.versionMapper.insertSelective(version);
        if (i > 0) {
            return ResponseBuildUtil.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)i);
        }
        return ResponseBuildUtil.build((RetCodeEnum)RetCodeEnum.INSERT_FILE);
    }

    @EnableValidate
    public ResponseParams getVersionList(@RequestBody GetVersionListReq req) {
        if (req.getId() == null) {
            VersionExample versionExample = new VersionExample();
            versionExample.createCriteria().andStatusEqualTo("NORMAL");
            versionExample.setOrderByClause("version_start_time desc");
            PageHelper.startPage((int)req.getPageNo(), (int)req.getPageSize());
            List versions = this.versionMapper.selectByExample(versionExample);
            return ResponseBuildUtil.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)Putil.build((List)versions));
        }
        Version version = this.versionMapper.selectByPrimaryKey(req.getId());
        return ResponseBuildUtil.build((CommonRetCode)CommonRetCode.SUCCESS, (Object)version);
    }

    private void insertuserPopRecod(Version version, String uid) {
        UserPopRecod userPopRecod = new UserPopRecod();
        userPopRecod.setCreateTime(new Date());
        userPopRecod.setItemId(version.getId());
        userPopRecod.setItemType("VERSION");
        userPopRecod.setUid(uid);
        this.userPopRecodMapper.insertSelective(userPopRecod);
    }

    private List<Date> getTodayData() {
        long current = System.currentTimeMillis();
        long zero = current / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
        long twelve = zero + 86400000L - 1L;
        Timestamp x = new Timestamp(zero);
        Timestamp x1 = new Timestamp(twelve);
        ArrayList<Date> dates = new ArrayList<Date>();
        dates.add(x);
        dates.add(x1);
        return dates;
    }
}

