package com.ella.util.redisnew;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.data.redis.core.RedisTemplate;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @ClassName SpringObjectRedisCache
 * @Description TODO
 * @Author liuwenzhao
 * @Date 2018/11/20 10:18
 * @Version
 **/
public class SpringObjectRedisCache implements ObjectCache {
    private RedisTemplate redisTemplate;
    private Logger logger= LoggerFactory.getLogger(this.getClass());

    SpringObjectRedisCache(RedisTemplate redisTemplate)
    {
        this.redisTemplate=redisTemplate;
    }


    /**
     * ---------------------------------------------------------------------- common
     */
    @Override
    public void expire(String key, Long expire) {
        redisTemplate.expire(key,expire, TimeUnit.SECONDS);
    }

    @Override
    public void delete(String key) {
        redisTemplate.delete(key);
    }

    @Override
    public void delete(String... keys) {
        List<String> collect = Arrays.stream(keys).filter(x -> StringUtils.isNotBlank(x)).collect(Collectors.toList());
        redisTemplate.delete(collect);
    }

    @Override
    public boolean haskey(String key) {
        return redisTemplate.hasKey(key);
    }


    /**
     * ---------------------------------------------------------------------- List
     */

    @Override
    public void lSet(String key, Object value) {
        redisTemplate.opsForList().leftPush(key,value);
    }

    @Override
    public void lSet(String key, Object[] values) {
        redisTemplate.opsForList().leftPushAll(key,values);
    }

    @Override
    public <T> T lGet(String key, Long index, Class<T> tClass) {
        T obj1=null;
        try {
            Object obj2=redisTemplate.opsForList().index(key,index);
            if(null!=obj2)
            {
                obj1=tClass.newInstance();
                BeanUtils.copyProperties(obj2,obj1);
            }
        }catch (Exception e) {
            logger.error("-----------------------------------run 4----------"+e.getMessage());
        }finally {
            return obj1;
        }
    }

    @Override
    public <T> T lGet(String key, Class<T> tClass) {
        T obj1=null;
        try {
            Object obj2 = redisTemplate.opsForList().rightPop(key);
            if(null!=obj2)
            {
                obj1=tClass.newInstance();
                BeanUtils.copyProperties(obj2,obj1);
            }
        } catch (Exception e) {
            logger.error("-----------------------------------run 4----------"+e.getMessage());
        }finally {
            return obj1;
        }
    }

    /**
     * ---------------------------------------------------------------------- hash
     */

    @Override
    public void hSet(String key, String HashKey, Object value) {
        redisTemplate.opsForHash().put(key,HashKey,value);
    }

    @Override
    public <T> T hGet(String key, String HashKey, Class<T> tClass) {
        T obj1=null;
        try {
            Object obj2 = redisTemplate.opsForHash().get(key,HashKey);
            if(null!=obj2)
            {
                obj1=tClass.newInstance();
                BeanUtils.copyProperties(obj2,obj1);
            }
        } catch (Exception e) {
            logger.error("-----------------------------------run 4----------"+e.getMessage());
        }finally {
            return obj1;
        }
    }

    /**
     * ---------------------------------------------------------------------- set
     */
    @Override
    public void sSet(String key, Object ... values) {
        redisTemplate.opsForSet().add(key, values);
    }

    @Override
    public <T> T sGet(String key, Class<T> tClass) {
        T obj1=null;
        try {
            Object obj2 = redisTemplate.opsForSet().pop(key);
            if(null!=obj2)
            {
                obj1=tClass.newInstance();
                BeanUtils.copyProperties(obj2,obj1);
            }
        } catch (Exception e) {
            logger.error("-----------------------------------run 4----------"+e.getMessage());
        }finally {
            return obj1;
        }
    }

    @Override
    public <T> Set<T>  getSetkey(String key,Class<T> tClass){
      return  redisTemplate.opsForSet().members(key);
    }

    @Override
    public void sDelete(String key, Object... values) {
        redisTemplate.opsForSet().remove(key, values);
    }

    /**
     * ---------------------------------------------------------------------- zset
     */
    @Override
    public void zSet(String key, Object value) {

    }

    @Override
    public <T> T zGet(String key, Class<T> tClass) {
        return null;
    }
}
