package com.ella.util.redisnew;

import java.util.Set;

/**
 * @ClassName ObjectCache
 * @Description TODO
 * @Author liuwenzhao
 * @Date 2018/11/20 10:13
 * @Version
 **/
public interface ObjectCache {
    /**
     * ---------------------------------------------------------------common
     */
    void expire(String key,Long exipre);
    void delete(String key);
    void delete(String ... keys);
    boolean haskey(String key);
    /**
     * ---------------------------------------------------------------list
     */

    void lSet(String key,Object value);
    void lSet(String key,Object[] values);
    <T> T lGet(String key, Long index, Class<T> tClass);
    <T> T lGet(String key,Class<T> tClass);

    /***
     * ----------------------------------------------------------------map
     */
    void hSet(String key,String hashKey,Object value);
    <T> T hGet(String key, String hashKey, Class<T> tClass);

    /***
     * ---------------------------------------------------------------set
     */

    void sSet(String key,Object ... values);
    <T> T sGet(String key,Class<T> tClass);

    <T> Set<T> getSetkey(String key, Class<T> tClass);
    void sDelete(String key, Object...values);

    /**
     * --------------------------------------------------------------zset
     */

    void zSet(String key,Object value);
    <T> T zGet(String key,Class<T> tClass);
}
