package com.ella.util.doc.impl;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

import com.ella.util.doc.annotations.FieldExplain;
import com.ella.util.doc.enums.DocTypeAlias;
import com.ella.util.doc.inf.Table;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.*;

/**
 * @author mc
 * @date 2018/7/13
 */
public class TableFromClz implements Table {
    List<String> list;
    String type;
    String groupId;
    String fieldName;
    Object fieldObj;
    String necessary;
    String docTypeAlias;
    String explain;

    public TableFromClz() {
    }

    public TableFromClz(List<String> list, String groupId,String type, String fieldName, Object fieldObj) {
        this.list = list;
        this.groupId = groupId;
        this.type=type;
        this.fieldName=fieldName;
        this.fieldObj = fieldObj;
    }

    @Override
    public void setTitle() {
        list.add("**" + fieldName + "说明：** ");
        list.add("");
        if ("param".equalsIgnoreCase(type)) {
            list.add("|参数名|必选|类型|说明|");
            list.add("|:----    |:---:|:---:|:-----   |");
            list.add("| ==========| ==== | ====|  ========================================  |");
        } else {
            list.add("|参数名|类型|说明|");
            list.add("|:----  |:-----: |:-----   |");
            list.add("| ==========| ==== | =====================================================  |");
        }
    }

    @Override
    public StringBuilder setElementTitle() {
        StringBuilder sb = new StringBuilder();
        if ("param".equalsIgnoreCase(type)) {
            sb.append("|").append(fieldName).append("|").append(necessary).append("|").append(docTypeAlias).append("|").append(explain).append("|");
        } else {
            sb.append("|").append(fieldName).append("|").append(docTypeAlias).append("|").append(explain).append("|");
        }
        return sb;
    }

    @Override
    public void create() throws Exception {
        Map<String, Object> objects = new LinkedHashMap<>();
        setTitle();
        if (fieldObj == null) return;
        Class<?> clz1 = fieldObj.getClass();
        List<Field> declaredFields = this.getClzFieldList(clz1);
        for (int i = 0; i < declaredFields.size(); i++) {
            FieldExplain annotation = declaredFields.get(i).getAnnotation(FieldExplain.class);
            groupId = StringUtils.isBlank(groupId) ? "default" : groupId;
            if (annotation != null && ArrayUtils.contains(annotation.groups(), groupId)) {
                docTypeAlias = DocTypeAlias.getAlias(declaredFields.get(i).getType());
                fieldName = declaredFields.get(i).getName();
                necessary = annotation.necessary().getValue();
                explain = annotation.explain();
                StringBuilder sb = setElementTitle();
                list.add(sb.toString());
                if ("array".equalsIgnoreCase(docTypeAlias) || "object".equalsIgnoreCase(docTypeAlias)) {
                    declaredFields.get(i).setAccessible(true);
                    Object o = null;
                    if (o == null) {
                        o = declaredFields.get(i).getType();
                    }
                    if ("array".equalsIgnoreCase(docTypeAlias)) {
                        ParameterizedType parameterizedType = (ParameterizedType) declaredFields.get(i).getGenericType();
                        o = parameterizedType.getActualTypeArguments()[0];
                    }
                    o = ((Class) o).newInstance();

                    objects.put(declaredFields.get(i).getName(), o);
                }
            }
        }
        list.add("");
        Iterator<Map.Entry<String, Object>> iterator = objects.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> next = iterator.next();
            fieldName = next.getKey();
            fieldObj = next.getValue();
            this.create();
        }
    }

    public List<Field> getClzFieldList( Class<?> clazz) {
        List<Field> list = new ArrayList<>();
        try {
            for (; clazz != Object.class; clazz = clazz.getSuperclass()) {
                Field[] fields = clazz.getDeclaredFields();
                list.addAll(Arrays.asList(fields));
            }
            list.forEach(s->System.out.println(s.getName()));
            return list;
        } catch (Exception e) {
            e.printStackTrace();
            return list;
        }
    }
}
