package com.ella.util.doc.annotations;


import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import com.ella.util.doc.enums.Necessary;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.RUNTIME;


@Documented
@Target({FIELD})
@Retention(RUNTIME)
public @interface FieldExplain {
    /**
     * <p>is necessary</p>
     *
     * @return
     */
    Necessary necessary() default Necessary.YES;

    /**
     * <p>explain of field</p>
     *
     * @return
     */
    String explain();


    /**
     * <p>groups of field</p>
     *
     * @return
     */
    String[] groups() default {"default"};

}
