package com.ella.util.doc.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import com.ella.util.doc.enums.EllaDeveloper;
import com.ella.util.doc.enums.EllaProject;
import com.ella.util.doc.enums.TableHelper;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * The interface Doc config.
 *
 * @author mc
 * @date 2018 /7/12
 */
@Documented
@Target({METHOD})
@Retention(RUNTIME)
public @interface DocConfig {

    /**
     * Developer ella developer.
     *
     * @return the ella developer
     */
    EllaDeveloper developer() default EllaDeveloper.ELLA;

    /**
     * Vo class.
     *
     * @return the class
     */
    Class<?> VO() default Object.class;

    /**
     * Dto class.
     *
     * @return the class
     */
    Class<?> DTO() default Object.class;

    /**
     * Type table helper.
     *
     * @return the table helper
     */
    TableHelper type() default TableHelper.JSON;

    /**
     * Expire flag string.
     *
     * @return the string
     */
    String expireFlag()default "1970-01-01 00:00:00";

    /**
     * Error string [ ].
     *
     * @return the string [ ]
     */
    String[] error() default {};

}
